<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class VisibilityPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    //used to check user type to display proper settings
    public $user_type;

    public $page_id; //subcard id, used in query
    public $checkifactive;

    public $card_custom_title;
    public $searchable;
    public $is_active;

    // lets connect
    public $connect_main;
    public $connect_bio;
    public $connect_icon;

    // public $feedback_form;
    //gallery
    public $gallery_main;
    public $gallery_bio;

    //short bio
    public $short_bio_enabled;

    //click here
    public $click_videos_enabled;
    public $click_gallery_enabled;

    //country
    public $country_enabled;

    //exchange contact
    // public $exchange_contact_enabled;

    //username
    public $username_enabled;

    //product price
    public $product_price_enabled;

    //services price
    public $services_price_enabled;

    //footer
    public $footer_enabled;

    public $getacard_enabled;

    //used for checking
    public $query;

    public $user;

    public function updateField($field)
    {
        if (!$this->user) {
            session()->flash('error', 'Unauthorized action.');
            return redirect('/settings/visibility');
        }

        if ($this->checkifactive > 0) {
            $setting = UserSettings::where('setting_key', $field)
                ->where('user_id', $this->user->id)
                ->whereNull('page_id')
                ->first();
        } else {

            $setting = UserSettings::where('setting_key', $field)
                ->where('page_id', $this->page_id)
                ->first();
        }

        $newValue = !($setting->setting_value ?? false);

        UserSettings::updateOrCreate(
            array_merge(['setting_key' => $field], $this->query),
            ['setting_value' => $newValue]
        );

        session()->flash('success', 'Visibility successfully updated!');

        // Redirect to the specified route
        return redirect('/settings/visibility');
    }

    public function displayUsername()
    {
        $this->updateField('display_username');
    }

    public function displayShortBio()
    {
        $this->updateField('display_short_bio');
    }

    public function displayCountry()
    {
        $this->updateField('display_country');
    }

    // public function displayExchangeContact()
    // {
    //     $this->updateField('exchange_contact_enabled');
    // }

    public function activateServicesPrice()
    {
        $this->updateField('services_price_enabled');
    }

    public function activateProductPrice()
    {
        $this->updateField('product_price_enabled');
    }

    public function activateFooter()
    {
        $this->updateField('footer_enabled');
    }

    public function activateGetaCard()
    {
        $this->updateField('getacard_enabled');
    }

    public function enableGalleryMain()
    {
        $this->updateField('gallery_main');
    }

    public function enableGalleryBio()
    {
        $this->updateField('gallery_bio');
    }

    public function enableClickVideos()
    {
        $this->updateField('click_videos_enabled');
    }

    public function enableClickGallery()
    {
        $this->updateField('click_gallery_enabled');
    }

    public function enableConnectMain()
    {
        $this->updateField('connect_main');
    }

    // public function enableFeedbackForm()
    // {
    //     $this->updateField('feedback_form');
    // }

    public function enableConnectBio()
    {
        $this->updateField('connect_bio');
    }

    public function enableConnectIcon()
    {
        $this->updateField('connect_icon');
    }

    public function searchVisibility()
    {
        $this->updateField('searchable');
    }

    // public function cardEnabled()
    // {
    //     $user = auth()->user();

    //     if (!$user) {
    //         session()->flash('error', 'Unauthorized action.');
    //         return redirect('/settings/visibility');
    //     }

    //     if ($this->checkifactive > 0) {
    //         $setting = User::where('id', auth()->user()->id)
    //             ->whereNull('page_id')
    //             ->pluck('is_active')
    //             ->first();

    //         $query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
    //     } else {

    //         $this->page_id = SubCard::where('user_id', auth()->user()->id)
    //             ->where('active_card', true)
    //             ->pluck('id')
    //             ->first();

    //         $setting = UserSettings::where('setting_key', 'display_username')
    //             ->where('page_id', $this->page_id)
    //             ->first();

    //         $query = ['user_id' => NULL, 'page_id' => $this->page_id];
    //     }

    //     $newValue = !($setting->setting_value ?? false);

    //     UserSettings::updateOrCreate(
    //         array_merge(['setting_key' => 'display_username'], $query),
    //         ['setting_value' => $newValue]
    //     );
    //     session()->flash('success', 'Username visibility successfully updated!');

    //     // Redirect to the specified route
    //     return redirect('/settings/visibility');
    // }

    public function viewSettings()
    {

        // Card title
        $this->card_custom_title = UserSettings::where($this->query)
            ->where('setting_key', 'card_custom_title')
            ->pluck('setting_value')
            ->first();

        // Searchable
        $this->searchable = UserSettings::where($this->query)
            ->where('setting_key', 'searchable')
            ->pluck('setting_value')
            ->first();

        $this->is_active = SubCard::where('id', $this->page_id)
            ->pluck('is_active')
            ->first();

        // Lets Connect on main card
        $this->connect_main = UserSettings::where($this->query)
            ->where('setting_key', 'connect_main')
            ->pluck('setting_value')
            ->first();

        // Lets Connect on bio page
        $this->connect_bio = UserSettings::where($this->query)
            ->where('setting_key', 'connect_bio')
            ->pluck('setting_value')
            ->first();

        $this->connect_icon = UserSettings::where($this->query)
            ->where('setting_key', 'connect_icon')
            ->pluck('setting_value')
            ->first();

        //feedback
        // $this->feedback_form = UserSettings::where($this->query)
        //     ->where('setting_key', 'feedback_form')
        //     ->pluck('setting_value')
        //     ->first();

        //gallery on main page
        $this->gallery_main = UserSettings::where($this->query)
            ->where('setting_key', 'gallery_main')
            ->pluck('setting_value')
            ->first();

        // Gallery on bio page
        $this->gallery_bio = UserSettings::where($this->query)
            ->where('setting_key', 'gallery_bio')
            ->pluck('setting_value')
            ->first();

        // Footer enabled
        $this->footer_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'footer_enabled')
            ->pluck('setting_value')
            ->first();

        $this->getacard_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'getacard_enabled')
            ->pluck('setting_value')
            ->first();

        // Country enabled
        $this->country_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'display_country')
            ->pluck('setting_value')
            ->first();

        //Exchange Contact
        // $this->exchange_contact_enabled = UserSettings::where($this->query)
        //     ->where('setting_key', 'exchange_contact_enabled')
        //     ->pluck('setting_value')
        //     ->first();

        //short bio enabled
        $this->short_bio_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'display_short_bio')
            ->pluck('setting_value')
            ->first();

        //username
        $this->username_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'display_username')
            ->pluck('setting_value')
            ->first();

        //product price
        $this->product_price_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'product_price_enabled')
            ->pluck('setting_value')
            ->first();

        $this->click_gallery_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'click_gallery_enabled')
            ->pluck('setting_value')
            ->first();

        $this->click_videos_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'click_videos_enabled')
            ->pluck('setting_value')
            ->first();

        //services price
        $this->services_price_enabled = UserSettings::where($this->query)
            ->where('setting_key', 'services_price_enabled')
            ->pluck('setting_value')
            ->first();

        if (!$this->card_custom_title) {
            $this->card_custom_title = $this->user->firstname . ' ' . $this->user->lastname;
        }

        $this->searchable = $this->searchable ?? true;

        $this->connect_main = $this->connect_main ?? true;

        $this->connect_bio = $this->connect_bio ?? false;

        $this->connect_icon = $this->connect_icon ?? true;

        // $this->feedback_form = $this->feedback_form ?? false;

        $this->gallery_bio = $this->gallery_bio ?? false;

        $this->click_gallery_enabled = $this->click_gallery_enabled ?? false;

        $this->click_videos_enabled = $this->click_videos_enabled ?? false;

        // if NULL, set to FALSE
        $this->gallery_main = $this->gallery_main ?? true;

        // if NULL, set to TRUE
        $this->footer_enabled = $this->footer_enabled ?? true;

        $this->getacard_enabled = $this->getacard_enabled ?? true;

        // if NULL, set to TRUE
        $this->country_enabled = $this->country_enabled ?? true;

        // if NULL, set to TRUE
        // $this->exchange_contact_enabled = $this->exchange_contact_enabled ?? true;

        // if NULL, set to TRUE
        $this->short_bio_enabled = $this->short_bio_enabled ?? true;

        // if NULL, set to TRUE
        $this->username_enabled = $this->username_enabled ?? true;

        // if NULL, set to TRUE
        $this->product_price_enabled = $this->product_price_enabled ?? true;

        // if NULL, set to TRUE
        $this->services_price_enabled = $this->services_price_enabled ?? true;
    }

    public function mount()
    {
        $this->user = auth()->user();
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->checkifactive = User::where('id', $this->user->id)->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->query = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', $this->user->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            // $this->query = ['user_id' => NULL, 'page_id' => $this->page_id];
            $this->query = ['page_id' => $this->page_id];
        }

        $this->user_type = $this->user->user_type;


        $this->viewSettings();
    }

    public function render()
    {
        return view('livewire.visibility-page')->title('Visibility | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
