<?php

namespace App\Livewire;

use App\Models\FormSubmission;
use App\Models\LeadCaptureForm;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;

class ViewFormSubmissionPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $contact_info;
    public $user;

    public $favicon;

    public $condition;

    public $firstname, $lastname, $phone, $email;

    public $page_id, $form_info;

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
    }

    // public function mount($id)
    // {
    //     $checkifactive = User::where('id', auth()->user()->id)
    //         ->where('active_card', true)->count();

    //     if ($checkifactive > 0) {
    //         $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
    //     } else {
    //         $this->page_id = SubCard::where('user_id', auth()->user()->id)
    //             ->where('active_card', true)
    //             ->pluck('id')
    //             ->first();
    //         $this->condition = ['page_id' => $this->page_id];
    //     }

    //     $checkIfUserForm = LeadCaptureForm::where('id', $id)
    //         ->where($this->condition)->exist();

    //     dd($checkIfUserForm);

    //     $this->contact_info = FormSubmission::where('id', $id)->first();

    //     if (!$this->contact_info) {
    //         abort(404, 'Page not found.');
    //     }
    // }

    public function mount($id)
    {
        // Determine if the user has an active main card
        $hasMainCard = User::where('id', auth()->id())
            ->where('active_card', true)
            ->exists();

        if ($hasMainCard) {
            $this->condition = [
                'user_id' => auth()->id(),
                'page_id' => null,
            ];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->id())
                ->where('active_card', true)
                ->value('id');

            $this->condition = [
                'page_id' => $this->page_id,
            ];
        }

        // Load the submission based on ID
        $this->contact_info = FormSubmission::find($id);

        if (! $this->contact_info) {
            abort(404, 'Page not found.');
        }

        // Check if the submission really belongs to the correct owner
        $isOwner = LeadCaptureForm::where('id', $this->contact_info->form_id)
            ->where($this->condition)
            ->exists();

        $this->form_info = LeadCaptureForm::where('id', $this->contact_info->form_id)
            ->where($this->condition)
            ->first();

        if (! $isOwner) {
            abort(403, 'You do not have permission to view this submission.');
        }
    }


    public function render()
    {
        return view('livewire.view-form-submission-page')->title('Form Submission | ' . $this->contact_info->firstname . ' ' . $this->contact_info->lastname)->layoutData([
            // 'favicon' => $this->favicon,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'site_url' => $this->site_url,
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
