<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Video;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;

class VideoPage extends Component
{
    use AuthorizesRequests;

    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $videos, $user_type;
    public $page_id; //subcard id, used in query

    public function videoManager()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);

            $this->videos = Video::where('user_id', auth()->user()->id)->where('page_id', NULL)->get();
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            // if main card is not active, get the infos from subcard
            // $this->maincard_active = false;
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->videos = Video::where('page_id', $this->page_id)->where('page_id', $this->page_id)->get();
        }

        if ($this->videos->isEmpty()) {
            $this->videos = 0;
        }

        $this->user_type = auth()->user()->user_type;
    }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->videoManager();
    }

    public function render()
    {
        // Check if user is authorize
        $this->authorize('view', Video::class);
        return view('pages.video')->title('Videos | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
