<?php

namespace App\Livewire;

use Illuminate\Database\Eloquent\Model;
use Livewire\Component;
use Livewire\Attributes\Validate;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use Spatie\Image\Image;
use App\Settings\CardDefaultsSetting;

class UploadAdImageModal extends Component
{
    public $ad_banner_w;
    public $ad_banner_h;

    use WithFileUploads;

    public Model $model;

    public $temporaryUrl;
    public ?string $croppedBlob;
    public $product_image;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif,heic,avif|max:5120')]
    public $image;

    public function handleCroppedImage($croppedBlob, $cropRegions, $imageSize)
    {
        Image::load($this->image->getRealPath())->width($imageSize['naturalWidth'])->height($imageSize['naturalHeight'])
            ->save();

        Image::load($this->image->getRealPath())
            ->manualCrop($cropRegions['width'], $cropRegions['height'], $cropRegions['x'], $cropRegions['y'])
            ->save();

        $this->croppedBlob = $croppedBlob;
        //this goes to AddAd.php
        $this->dispatch('adImage', $this->image->getRealPath());
        //this goes to ProductImageField.php
        $this->dispatch('setAdImage', $this->croppedBlob);
    }

    //  public function updateThumbnail()
    // {
    //     // $this->validate();
    //     // check if user is logged in
    //     if (auth()->user()) {

    //         if ($this->thumbnail) {
    //             // if main card
    //             if ($this->mainCard) {
    //                 // Check if the user already has a profile picture and delete it
    //                 if (auth()->user()->thumbnail && file_exists(storage_path('app/public/' . auth()->user()->thumbnail))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . auth()->user()->thumbnail));
    //                 }

    //                 auth()->user()->thumbnail = $this->thumbnail->storePublicly('thumbnails', 'public');
    //                 // Update the user data
    //                 $updated = auth()->user()
    //                     ->update([
    //                         'thumbnail' => $this->thumbnail->storePublicly('thumbnails', 'public')
    //                     ]);
    //             } else {
    //                 // if subcard
    //                 // Check if the user already has a profile picture and delete it
    //                 $checkSubCardThumbnail = SubCard::where('active_card', true)->where('user_id', auth()->user()->id)->pluck('thumbnail')->first();

    //                 if ($checkSubCardThumbnail && file_exists(storage_path('app/public/' . $checkSubCardThumbnail))) {
    //                     // Delete the old profile picture
    //                     unlink(storage_path('app/public/' . $checkSubCardThumbnail));
    //                 }

    //                 $updated = auth()->user()->subcards()
    //                     ->where('active_card', true)
    //                     ->update([
    //                         'thumbnail' => $this->thumbnail->storePublicly('thumbnails', 'public')
    //                     ]);
    //             }

    //             if ($updated) {
    //                 session()->flash('success', 'Thumbnail successfully updated.');
    //             } else {
    //                 session()->flash('error', 'Error in updating thumbnail.');
    //             }

    //             $tempFilePath = $this->thumbnail->getRealPath();

    //             if (file_exists($tempFilePath)) {
    //                 unlink($tempFilePath);  // Delete the temporary file explicitly
    //             }
    //         }
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //         // return redirect()->route('dashboard.index');

    //     }
    //     return $this->redirect('/customization/card-customization', navigate: true);
    // }

    // After uploading the image, manually validate. if image is valid, display on the modal
    public function updatedImage()
    {
        try {
            $this->validate([
                'image' => 'image|mimes:jpeg,png,jpg,webp,heif,heic,avif|max:5120',
            ]);

            $this->temporaryUrl = $this->image->temporaryUrl();
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Handle validation failure
            session()->flash('error', 'The file must be an image (jpeg, png, jpg, heif or webp).');
            return $this->redirect('/ads/add', navigate: true);
        }
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->ad_banner_w = $default->ad_banner_w;
        $this->ad_banner_h = $default->ad_banner_h;
        return view('livewire.upload-ad-image-modal');
    }
}
