<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use App\Models\UpgradeRequest;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Settings\CardDefaultsSetting;

class UpgradeCheckoutManual extends Component
{
    use WithFileUploads;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $card_title;
    public $page_title;
    public $logo;

    public $user;
    public $fullname;
    public $favicon;

    public $site_button_color;
    public $site_button_text_color;

    public $condition;
    public $selected_plan;
    public $selected_plan_text;
    public $term_description;
    public $price;
    public $price_link;
    public $page_id;

    public $receipt;
    public $checkifactive;

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->id())
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->id())
                ->where('active_card', true)
                ->value('id')
                ->first();
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->app_name = $default->app_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;

        $this->site_button_text_color = $default->site_button_text_color;
        $this->site_button_color = $default->site_button_color;

        $this->site_button_text_color = $this->site_button_text_color ?: '#000';
        $this->site_button_color = $this->site_button_color ?: '#facc15';

        $this->selected_plan = request()->query('selected_plan');

        if (!in_array($this->selected_plan, ['basic', 'gold',  'platinum']) && $default->manual_capture_mode_annual_only) {
            abort(404, 'Invalid plan.');
        }

        if (!in_array($this->selected_plan, ['basic', 'basic_m', 'gold', 'gold_m', 'platinum', 'platinum_m']) && !$default->manual_capture_mode_annual_only) {
            abort(404, 'Invalid plan');
        }

        if (!$default->platinum_enabled && auth()->user()->user_type === 'Platinum') {
            abort(403, 'Access denied');
        } else if (!$default->platinum_enabled && auth()->user()->user_type === 'Gold') {
            abort(403, 'Access denied');
        }

        if ($this->selected_plan == 'basic' && in_array(auth()->user()->user_type, ['Free', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text =  $default->term_basic . " (Annual)";
            $this->term_description = $default->term_description_basic;
            $this->price = $default->price_basic_yearly;
            $this->price_link = $default->manual_basic_card_link;
        } else if ($this->selected_plan == 'basic_m' && in_array(auth()->user()->user_type, ['Free', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text = $default->term_basic . " (Monthly)";
            $this->term_description = $default->term_description_basic;
            $this->price = $default->price_basic_monthly;
            $this->price_link = $default->manual_basic_card_monthly_link;
        } else if ($this->selected_plan == 'gold' && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text = $default->term_gold . " (Annual)";
            $this->term_description = $default->term_description_gold;
            $this->price = $default->price_gold_yearly;
            $this->price_link = $default->manual_gold_card_link;
        } else if ($this->selected_plan == 'gold_m' && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text = $default->term_gold . " (Monthly)";
            $this->term_description = $default->term_description_gold;
            $this->price = $default->price_gold_monthly;
            $this->price_link = $default->manual_gold_card_monthly_link;
        } else if ($this->selected_plan == 'platinum' && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Gold', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text = $default->term_platinum . " (Annual)";
            $this->term_description = $default->term_description_platinum;
            $this->price = $default->price_platinum_yearly;
            $this->price_link = $default->manual_platinum_card_link;
        } else if ($this->selected_plan == 'platinum_m' && in_array(auth()->user()->user_type, ['Free', 'Basic',  'Gold', 'Sponsored', 'Influencer'])) {
            $this->selected_plan_text = $default->term_platinum . " (Monthly)";
            $this->term_description = $default->term_description_platinum;
            $this->price = $default->price_platinum_monthly;
            $this->price_link = $default->manual_platinum_card_monthly_link;
        } else {
            abort(403, 'Invalid access');
        }
    }

    public function requestUpgradeCard()
    {
        $validated = $this->validate(
            [
                'receipt'     => 'required|image|mimes:jpeg,jpg,png,webp|max:5120',
            ]
        );

        $validated['user_id'] = auth()->id();
        $validated['old_plan'] = auth()->user()->user_type;
        $validated['page_id'] = $this->page_id;
        $validated['plan'] = $this->selected_plan;

        if ($this->receipt) {
            $validated['receipt'] =  $this->receipt->storePublicly('receipts', 'public');
        }

        try {
            $create = UpgradeRequest::create($validated);

            if ($create) {
                session()->flash('success', 'Request send. Thank you.');
            } else {
                session()->flash('error', 'Error submitting the form.');
            }
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }

        return $this->redirect('/dashboard', navigate: true);
    }

    public function render()
    {
        return view('livewire.upgrade-checkout-manual')->title("Upgrade Business Card | " . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'thumbnail' => $this->thumbnail,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'site_button_text_color' => $this->site_button_text_color,
            'site_button_color' => $this->site_button_color,
            'app_name' => $this->app_name,
        ]);
    }
}
