<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use App\Models\UserSettings;

class SwitchCardComponent extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    public $user;
    public $card_title;
    public $condition;
    public $page_id;

    public function mount()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'profile_pic', 'firstname', 'lastname', 'user_type']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->user = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->first(['username', 'firstname', 'lastname', 'profile_pic']);
            $this->condition = ['page_id' => $this->page_id];
        }

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function render()
    {
        // dd(auth()->user()->id, $this->page_id, $this->card_title, $this->user->firstname, $this->user->lastname);
        return view('livewire.switch-card-component');
    }
}
