<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;
use App\Jobs\SyncUserSubscriptionType;
use Carbon\Carbon;
use Laravel\Cashier\Cashier;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SubscriptionPage extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public $user;
    public $card_title;
    public $condition;

    public $plan_id;

    public $basic_card;
    public $gold_card;
    public $platinum_card;
    public $is_test_mode;

    public $new_user_type;

    public $current_period_end;
    public $current_period_start;

    public $platinum_enabled;
    public $manual_capture_mode;

    // public function mount()
    // {
    //     $default = app(CardDefaultsSetting::class);
    //     $this->is_test_mode = $default->test_mode;

    //     $this->basic_card = $this->is_test_mode ? $default->test_basic_yearly : $default->live_basic_yearly;

    //     $this->gold_card = $this->is_test_mode ? $default->test_gold_yearly : $default->live_gold_yearly;

    //     $this->platinum_card = $this->is_test_mode ? $default->test_platinum_yearly : $default->live_platinum_yearly;

    //     $this->plan_id = auth()->user()->subscription()->asStripeSubscription()->plan->id;

    //     if ($this->basic_card == $this->plan_id) {
    //         $this->new_user_type = 'Basic';
    //     } elseif ($this->gold_card == $this->plan_id) {
    //         $this->new_user_type = 'Gold';
    //     } elseif ($this->platinum_card == $this->plan_id) {
    //         $this->new_user_type = 'Platinum';
    //     }

    //     User::update(
    //         [
    //             'user_type' => $this->new_user_type
    //         ],
    //     );

    //     $this->profileSettings();
    // }

    public function mount()
    {
        // $this->plan_id = auth()->user()->subscription()->asStripeSubscription()->plan->id;

        // dd(auth()->user()->subscription());

        // $this->current_period_start = Carbon::createFromTimestamp(
        //     auth()->user()->subscription()->asStripeSubscription()->current_period_start
        // )->format('M j Y');

        // $this->current_period_end = Carbon::createFromTimestamp(
        //     auth()->user()->subscription()->asStripeSubscription()->current_period_end
        // )->format('M j Y');

        // dd($this->current_period_start, $this->current_period_end);

        // dispatch_sync(new SyncUserSubscriptionType(auth()->user()));
        $this->profileSettings();
    }

    public function profileSettings()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'profile_pic', 'firstname', 'lastname', 'user_type', 'access']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->first(['username', 'firstname', 'lastname', 'profile_pic']);
            // dd($this->user);
            // $this->condition = ['user_id' => auth()->user()->id, 'page_id' => $this->user->id];
            $this->condition = ['page_id' => $this->user->id];
        }

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;

        $this->platinum_enabled = $default->platinum_enabled;
        $this->manual_capture_mode = $default->manual_capture_mode;
        // $this->authorize('accessPremiumContent', User::class);
        //dd(auth()->user()->subscribed());
        // dd($this->user->user_type);
        return view('livewire.subscription-page')->title('Subscription | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
