<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;
use App\Models\Video;
use App\Models\SubCard;
use App\Models\User;

class SortableVideo extends Component
{
    use AuthorizesRequests;

    public $video_id;
    public $link;
    public $title;

    public $videos;
    public $page_id, $condition;

    public function activate($video_id)
    {
        $this->video_id = $video_id;

        $video = Video::where('id', $this->video_id)
            ->where($this->condition)
            ->first();

        if ($video) {
            //If true, change to false. If false, change to true
            $video['is_active'] = !$video['is_active'];
            $video->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/video', navigate: true);
    }

    // public function delete($video_id)
    // {
    //     // Check if user is authorize
    //     $this->authorize('delete', Video::class);
    //     $this->video_id = $video_id;
    //     //check if video exist and belongs to the user
    //     $video = Video::where('id', $this->video_id)
    //         ->where('user_id', auth()->user()->id)
    //         ->first();

    //     // If exist
    //     if ($video->isNotEmpty()) {

    //         if ($video->thumbnail && Storage::disk('public')->exists($video->thumbnail)) {
    //             Storage::disk('public')->delete($video->thumbnail);
    //         }

    //         //Delete
    //         Video::where('id', $this->video_id)->where('user_id', auth()->user()->id)->delete();

    //         session()->flash('success', 'Video successfully deleted!');
    //     } else {
    //         session()->flash('error', 'Unauthorized action.');
    //     }
    //     return $this->redirect('/dashboard/video', navigate: true);
    // }


    public function delete($video_id)
    {
        // Find video that belongs to the user
        $video = Video::where('id', $video_id)
            ->where($this->condition)
            ->first();

        if (! $video) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/dashboard/video', navigate: true);
        }

        // Authorize against the model instance
        $this->authorize('delete', $video);

        // Delete thumbnail if exists
        if ($video->thumbnail && Storage::disk('public')->exists($video->thumbnail)) {
            Storage::disk('public')->delete($video->thumbnail);
        }

        // Delete the video record
        $video->delete();

        session()->flash('success', 'Video successfully deleted!');

        return $this->redirect('/dashboard/video', navigate: true);
    }

    public function updateOrder(array $order)
    {
        Video::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    { // Check if user is authorize

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        if (auth()->user()->user_type == 'Basic') {
            $this->videos =
                Video::where($this->condition)
                ->ordered()
                ->limit(1)
                ->get();
        } else {
            $this->videos =
                Video::where($this->condition)
                ->ordered()
                // ->orderBy('order', 'asc')
                ->get();
        }

        $this->authorize('view', Video::class);
        return view('livewire.sortable-video', [
            'videos' => $this->videos
        ]);
    }
}
