<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\TrustedNetwork;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class SortableTrustedNetwork extends Component
{
    public $link;
    public $title;

    public $page_id;
    public $members;
    public $team_id;

    public $checkifactive;
    public $condition;

    public function activate($network_id)
    {
        $network = TrustedNetwork::where('id', $network_id)
            ->where($this->condition)
            ->first();

        if ($network) {
            //If true, change to false. If false, change to true
            $network['is_accepted'] = !$network['is_accepted'];
            $network->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/trusted-network', navigate: true);
    }

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            TrustedNetwork::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('user_id', auth()->user()->id);
            });
        } else {
            TrustedNetwork::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function delete($id)
    {
        $check = TrustedNetwork::where('id', $id)
            ->where($this->condition)
            ->delete();

        if ($check) {
            session()->flash('success', 'Network successfully removed!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect(route('dashboard.trustednetwork'), navigate: true);
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        $networksMain = TrustedNetwork::join('users', 'trusted_network.member_id', '=', 'users.id')
            ->where('trusted_network.card_type', 'main')
            ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
            ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
            ->select([
                'trusted_network.id as member_id',
                'trusted_network.card_type',
                'trusted_network.member_id as entity_id',
                'trusted_network.order',
                'trusted_network.is_accepted',
                'users.username',
                'users.firstname',
                'users.lastname',
                'users.profile_pic',
                'users.job_title',
                DB::raw('"main" as entity_type'),
            ]);

        $networksSub = TrustedNetwork::join('subcards', 'trusted_network.member_id', '=', 'subcards.id')
            ->where('trusted_network.card_type', 'sub')
            ->when(isset($this->condition['user_id']), fn($q) => $q->where('trusted_network.user_id', $this->condition['user_id']))
            ->when(isset($this->condition['page_id']), fn($q) => $q->where('trusted_network.page_id', $this->condition['page_id']))
            ->select([
                'trusted_network.id as member_id',
                'trusted_network.card_type',
                'trusted_network.member_id as entity_id',
                'trusted_network.order',
                'trusted_network.is_accepted',
                'subcards.username',
                'subcards.firstname',
                'subcards.lastname',
                'subcards.profile_pic',
                'subcards.job_title',
                DB::raw('"sub" as entity_type'),
            ]);

        $this->members = $networksMain->union($networksSub)->orderBy('order')->get();
        return view('livewire.sortable-trusted-network', [
            'members' => $this->members
        ]);
    }
}
