<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Product;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableSubscriptionProducts extends Component
{
    use AuthorizesRequests;

    public $product_id;
    public $link;
    public $title;

    public $checkifactive;
    public $page_id;
    public $subscriptions;
    public $condition;
    public $username;

    public function activate($product_id)
    {
        $this->product_id = $product_id;

        $product = Product::where('id', $this->product_id)
            ->where($this->condition)
            ->first();

        if ($product) {
            //If true, change to false. If false, change to true
            $product['is_active'] = !$product['is_active'];
            $product->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/subscriptions', navigate: true);
    }

    public function delete($product_id)
    {
        // Check if user is authorize
        $this->authorize('delete', Product::class);
        $this->product_id = $product_id;
        //check if button exist and belongs to the user
        $product = Product::where('id', $this->product_id)->where($this->condition)->first();

        // If exist
        if ($product) {
            //Delete
            $product->delete();
            session()->flash('success', 'Product successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/subscriptions', navigate: true);
    }

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            Product::setNewOrder($order, 1, 'id', function ($query) {
                $query->whereBelongsTo(auth()->user());
            });
        } else {
            Product::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
            $this->username = auth()->user()->username;
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->username = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('username')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->subscriptions =  Product::where($this->condition)->where('type', 'subscription')->ordered()->get();

        // Check if user is authorize
        $this->authorize('view', Product::class);
        return view('livewire.sortable-subscription-products', [
            'subscriptions' => $this->subscriptions
        ]);
    }
}
