<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Sale;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;

class SortableSalesPage extends Component
{
    use AuthorizesRequests;

    public $sales_id;
    public $link;
    public $title;

    public $page_id;
    public $sales;
    public $username;
    public $condition;

    public function activate($sales_id)
    {
        $this->sales_id = $sales_id;

        $sale = Sale::where('id', $this->sales_id)
            ->where($this->condition)
            ->first();

        if ($sale) {
            //If true, change to false. If false, change to true
            $sale['is_active'] = !$sale['is_active'];
            $sale->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/sales', navigate: true);
    }

    public function delete($sales_id)
    {
        // Find sales that belongs to the user
        $sale = Sale::where('id', $sales_id)
            ->where($this->condition)
            ->first();

        if (! $sale) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/dashboard/sales', navigate: true);
        }

        // Authorize against the model instance
        $this->authorize('delete', $sale);

        // Delete image if exists
        if ($sale->image && Storage::disk('public')->exists($sale->image)) {
            Storage::disk('public')->delete($sale->image);
        }

        // Delete the sales record
        $sale->delete();

        session()->flash('success', 'Sales page successfully deleted!');

        return $this->redirect('/dashboard/sales', navigate: true);
    }

    // public function updateOrder(array $order)
    // {
    //     Sale::setNewOrder($order, 1, 'id', function ($query) {
    //         $query->whereBelongsTo(auth()->user());
    //     });
    // }

    public function updateOrder(array $order)
    {
        Sale::setNewOrder($order, 1, 'id', function ($query) {
            $query->where(function ($q) {
                $q->where('user_id', auth()->id())
                    ->orWhereIn('page_id', auth()->user()->subcards->pluck('id'));
            });
        });
    }

    public function mount()
    {
        $this->username = auth()->user()->username;
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function render()
    {
        $this->sales =  Sale::where($this->condition)->ordered()->get();
        // Check if user is authorize
        $this->authorize('view', Sale::class);
        return view('livewire.sortable-sales-page', [
            'sales' => $this->sales
        ]);
    }
}
