<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;

class SortablePaymentLink extends Component
{
    public $payment_id;
    public $link;
    public $title;

    public $payments;
    public $page_id;
    public $condition;

    public function activate($payment_id)
    {
        $this->payment_id = $payment_id;

        $payment = Button::where('id', $this->payment_id)
            ->where($this->condition)
            ->where('view', 'payments')
            ->first();

        if ($payment) {
            //If true, change to false. If false, change to true
            $payment['is_active'] = !$payment['is_active'];
            $payment->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/payments', navigate: true);
    }

    public function delete($payment_id)
    {
        $this->payment_id = $payment_id;
        $check = Button::where('id', $this->payment_id)
            ->where($this->condition)
            ->first();

        if ($check) {
            $check->delete();
            session()->flash('success', 'Payment link successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/payments', navigate: true);
    }

    public function getLink($id)
    {
        $payment = Button::where('id', $id)->first(['link', 'title']);
        $this->link = $payment->link;
        $this->title = $payment->title;

        //Send to ButtonEditActionSheet
        $this->dispatch('send_link', $this->link);
        $this->dispatch('send_title', $this->title);
        $this->dispatch('send_id', $id);
    }

    public function updateOrder(array $order)
    {
        Button::setNewOrder($order, 1, 'id', function ($query) {
            $query->whereBelongsTo(auth()->user());
        });
    }

    public function render()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->payments = Button::where($this->condition)->where('view', 'payments')->ordered()->get();

        return view('livewire.sortable-payment-link', [
            'payments' => $this->payments
        ]);
    }
}
