<?php

namespace App\Livewire;

use App\Models\FormSubmission;
use Livewire\Component;
use App\Models\LeadCaptureForm;
use App\Models\SubCard;
use App\Models\User;

class SortableFormSubmission extends Component
{
    public $page_id;
    public $submissions;
    public $form_id;

    public $checkifactive, $condition;

    public function delete($id)
    {
        $check = FormSubmission::where('id', $id)->first();

        if ($check) {
            FormSubmission::where('id', $id)->delete();
            $check->delete();

            session()->flash('success', 'Form submission successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/form/edit/' . $this->form_id, navigate: true);
    }

    public function mount($form_id)
    {
        $this->form_id = $form_id;

        $this->submissions = FormSubmission::where('form_id', $this->form_id)
            ->orderBy('created_at', 'desc')
            ->get();

        // dd($this->submissions);
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        return view('livewire.sortable-form-submission', [
            'submissions' => $this->submissions
        ]);
    }
}
