<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Event;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;

class SortableEvent extends Component
{
    use AuthorizesRequests;

    public $event_id;
    public $link;
    public $title;

    public $page_id;
    public $events;
    public $condition;
    public $username;
    public $checkifactive;

    public function activate($event_id)
    {
        $this->event_id = $event_id;

        $event = Event::where('id', $this->event_id)
            ->where($this->condition)
            ->first();

        if ($event) {
            //If true, change to false. If false, change to true
            $event['is_active'] = !$event['is_active'];
            $event->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/event', navigate: true);
    }

    public function delete($event_id)
    {
        // Find event that belongs to the user
        $event = Event::where('id', $event_id)
            ->where($this->condition)
            ->first();

        if (! $event) {
            session()->flash('error', 'Unauthorized action.');
            return $this->redirect('/dashboard/event', navigate: true);
        }

        // Authorize against the model instance
        $this->authorize('delete', $event);

        // Delete image if exists
        if ($event->image && Storage::disk('public')->exists($event->image)) {
            Storage::disk('public')->delete($event->image);
        }

        // Delete the event record
        $event->delete();

        session()->flash('success', 'Event successfully deleted!');

        return $this->redirect('/dashboard/event', navigate: true);
    }

    public function updateOrder(array $order)
    {
        if ($this->checkifactive > 0) {
            Event::setNewOrder($order, 1, 'id', function ($query) {
                $query->whereBelongsTo(auth()->user());
            });
        } else {
            Event::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];

            $this->username = auth()->user()->username;
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->username = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('username')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }
    }

    public function render()
    {
        $this->events =  Event::where($this->condition)->ordered()->get();

        // Check if user is authorize
        $this->authorize('view', Event::class);
        return view('livewire.sortable-event', [
            'events' => $this->events
        ]);
    }
}
