<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Direction;
use App\Models\SubCard;
use App\Models\User;

class SortableDirectionLink extends Component
{
    public $button_id;
    public $link;
    public $title;

    public $page_id;
    public $buttons;
    public $condition;
    public $checkifactive;

    public function activate($button_id)
    {
        $this->button_id = $button_id;

        $button = Direction::where('id', $this->button_id)
            ->where($this->condition)
            ->first();

        if ($button) {
            //If true, change to false. If false, change to true
            $button['is_active'] = !$button['is_active'];
            $button->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/directions', navigate: true);
    }

    public function delete($button_id)
    {
        $this->button_id = $button_id;
        $check = Direction::where('id', $this->button_id)
            ->where($this->condition)
            ->first();

        if ($check) {
            $check->delete();
            session()->flash('success', 'Direction link successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }
        return $this->redirect('/dashboard/directions', navigate: true);
    }

    public function getLink($id)
    {
        $button = Direction::where('id', $id)->first(['link', 'title']);
        $this->link = $button->link;
        $this->title = $button->title;
    }

    public function updateOrder(array $order)
    {
        // Direction::setNewOrder($order, 1, 'id', function ($query) {
        //     $query->whereBelongsTo(auth()->user());
        // });

        if ($this->checkifactive > 0) {
            Direction::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('user_id', auth()->user()->id);
            });
        } else {
            Direction::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->buttons =  Direction::where($this->condition)->ordered()->get();

        return view('livewire.sortable-direction-link', [
            'buttons' => $this->buttons
        ]);
    }
}
