<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\ProductCategory;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class SortableCategory extends Component
{
    use AuthorizesRequests;

    public $product_id;
    public $link;
    public $title;

    public $page_id;
    public $categories;
    public $condition;
    public $checkifactive;

    public function activate($product_id)
    {
        $this->product_id = $product_id;

        $product = ProductCategory::where('id', $this->product_id)
            ->where($this->condition)
            ->first();

        if ($product) {
            //If true, change to false. If false, change to true
            $product['is_active'] = !$product['is_active'];
            $product->save();
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/product', navigate: true);
    }

    public function delete($product_id)
    {
        // Check if user is authorize
        // $this->authorize('delete', ProductCategory::class);
        $this->product_id = $product_id;
        //check if button exist and belongs to the user
        $product = ProductCategory::where('id', $this->product_id)->where($this->condition)->first();

        // If exist
        if ($product) {
            //Delete
            $product->delete();
            session()->flash('success', 'Product successfully deleted!');
        } else {
            session()->flash('error', 'Unauthorized action.');
        }

        return $this->redirect('/dashboard/product', navigate: true);
    }

    public function updateOrder(array $order)
    {
        // ProductCategory::setNewOrder($order, 1, 'id', function ($query) {
        //     $query->whereBelongsTo(auth()->user());
        // });

        if ($this->checkifactive > 0) {
            ProductCategory::setNewOrder($order, 1, 'id', function ($query) {
                $query->whereBelongsTo(auth()->user());
            });
        } else {
            ProductCategory::setNewOrder($order, 1, 'id', function ($query) {
                $query->where('page_id', $this->page_id);
            });
        }
    }

    public function render()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->categories =  ProductCategory::where($this->condition)->ordered()->get();
        // Check if user is authorize
        // $this->authorize('view', ProductCategory::class);
        return view('livewire.sortable-category', [
            'categories' => $this->categories
        ]);
    }
}
