<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Social;
use App\Models\User;
use App\Settings\CardDefaultsSetting;
use App\Models\SubCard;

class SocialPage extends Component
{
    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $user_type;
    public $socials;
    public $button_id;
    public $link;

    public $page_id; //subcard id, used in query

    public function socialLinksSettings()
    {

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if active, get the datas and set to form
        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);
            $this->socials = Social::where('user_id', auth()->user()->id)->where('page_id', NULL)->get();
        } else {

            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);
            // if main card is not active, get the infos from subcard
            // $this->maincard_active = false;
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->socials = Social::where('page_id', $this->page_id)->get();
        }

        // dd($this->socials);
        $this->user_type = auth()->user()->user_type;

        if ($this->socials->isEmpty()) {
            $this->socials = 0;
        }
    }
    // function to get link and pass to edit modal
    // public function getLink($id)
    // {
    //     $this->link = Auth::user()->socials()->where('id', $id)->pluck('link')->first();
    //     $this->dispatch('send_link', $this->link);
    //     $this->dispatch('send_id', $id);
    // }

    // public function destroy($button_id)
    // {
    //     $this->button_id = $button_id;
    //     //check if button exist and belongs to the user
    //     $check = Social::where('id', $this->button_id)->where('user_id', Auth::user()->id)->get();

    //     // If exist
    //     if ($check->isNotEmpty()) {
    //         //Delete
    //         Social::where('id', $this->button_id)->where('user_id', Auth::user()->id)->delete();
    //     }
    // }

    // public function active($button_id)
    // {
    //     $this->button_id = $button_id;
    //     $validated = $this->validate([
    //         'button_id' => 'required|integer'
    //     ]);

    //     $social = Social::where('id', $validated['button_id'])
    //         ->where('user_id', Auth::user()->id)->first();

    //     if ($social) {
    //         //If true, change to false. If false, change to true
    //         $social['is_active'] = !$social['is_active'];
    //         $social->save();
    //     }
    // }

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->socialLinksSettings();
    }

    public function render()
    {
        return view('pages.social')->title('Social Links | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
