<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class ServiceImageField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $service_image;

    #[On('setServiceImage')]
    public function setServiceImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
        // dd('Triggered set service image');
    }

    #[On('setEditServiceImage')]
    public function setServiceImageEdit($service_image)
    {
        $this->service_image = $service_image;
    }

    public function render()
    {
        return view('livewire.service-image-field');
    }
}
