<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class SelectCardPlan extends Component
{
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $logo;
    public $mockup;
    public $free_trial_duration, $free_trial_enabled;
    public $platinum_enabled;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->logo = $default->logo;
        $this->mockup = $default->mockup;
        $this->free_trial_duration = $default->free_trial_duration;
        $this->free_trial_enabled = $default->free_trial_enabled;
        $this->platinum_enabled = $default->platinum_enabled;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;
    }

    public function render()
    {
        return view('livewire.select-card-plan')->title('Select Card | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
