<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\Button;
use App\Models\Network;
use App\Models\Social;
use App\Models\SubCard;
use App\Settings\CardDefaultsSetting;

class SaveToNetworkButton extends Component
{
    public $page_id;
    public $checkifactive;
    public $bookmarked;
    public $username;
    public $network;
    public $card_type;
    public $query;

    public function saveContact()
    {
        // dd($this->username);
        if ($this->checkifactive > 0) {
            // $user = User::where('id', auth()->user()->id)
            //     ->where('active_card', true)
            //     ->pluck('id')
            //     ->first();

            $this->query = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            // $this->query = ['user_id' => NULL, 'page_id' => $this->page_id];
            // if subcard, get id
            $user_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->query = ['page_id' => $user_id];
        }

        $save = Network::create([
            ...$this->query,
            'network_id' => $this->network,
            'card_type' => $this->card_type,
            'type' => 'saved',
        ]);

        if ($save) {
            session()->flash('success', 'Contact Bookmarked!');
        } else {
            session()->flash('error', 'Error bookmarking the contact.');
        }

        return $this->redirect('/' . $this->username, navigate: true);
    }

    public function deleteContact()
    {
        // check if network is existing and active
        if ($this->network) {
            $delete = Network::where($this->query)
                ->where('network_id', $this->network)->delete();

            if ($delete) {
                session()->flash('success', 'Contact removed. It will now disappear on your network tab.');
            } else {
                session()->flash('error', 'Error removing contact.');
            }
        }

        return $this->redirect('/' . $this->username, navigate: true);
    }

    public function bookmarkContact($username)
    {
        // also check subcard

        if ($this->bookmarked) {
            // delete
            $this->deleteContact();
        } else {
            //save
            $this->saveContact();
        }
    }

    public function mount($username)
    {
        $this->username = $username;
        // check if network added is a main card or a subcard
        $this->network = User::where('username', $username)
            ->where('is_active', true)->pluck('id')->first();
        // dd($this->network);
        $this->card_type = 'main';

        //check if current card is a main card or subcard
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        // if subcard, get id
        $this->page_id = SubCard::where('user_id', auth()->user()->id)
            ->where('active_card', true)
            ->pluck('id')
            ->first();

        // if network is main card
        if ($this->network) {
            if ($this->checkifactive > 0) {
                // if user main card is used, check if network main card is recorded
                $is_bookmarked = Network::join('users', 'network.network_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->where('network.user_id', auth()->user()->id)
                    ->where('network.card_type', 'main')
                    ->pluck('network.network_id')->first();
            } else {
                // if user sub card is used, check if network main card is recorded
                $is_bookmarked = Network::join('users', 'network.network_id', '=', 'users.id')
                    ->where('users.username', $username)
                    ->where('network.page_id', $this->page_id)
                    ->where('network.card_type', 'main')
                    ->pluck('network.network_id')->first();
            }
        }
        // if network is sub card
        else {
            $this->network = SubCard::where('username', $username)
                ->where('is_active', true)->pluck('id')->first();
            $this->card_type = 'sub';

            if ($this->checkifactive > 0) {
                $is_bookmarked = Network::join('subcards', 'network.network_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    ->where('network.user_id', auth()->user()->id)
                    ->where('network.card_type', 'sub')
                    ->pluck('network.network_id')->first();
            } else {
                $is_bookmarked = Network::join('subcards', 'network.network_id', '=', 'subcards.id')
                    ->where('subcards.username', $username)
                    ->where('network.page_id', $this->page_id)
                    ->where('network.card_type', 'sub')
                    ->pluck('network.network_id')->first();
            }
        }

        if ($is_bookmarked) {
            $this->bookmarked = true;
        } else {
            $this->bookmarked = false;
        }
    }

    public function render()
    {
        return view('livewire.save-to-network-button');
    }
}
