<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class SalesPageThumbnailField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $sales_thumbnail;

    #[On('setSalesImage')]
    public function setSalesImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditSalesImage')]
    public function setEditSalesImage($sales_thumbnail)
    {
        $this->sales_thumbnail = $sales_thumbnail;
    }

    public function render()
    {
        return view('livewire.sales-page-thumbnail-field');
    }
}
