<?php

namespace App\Livewire;

use Livewire\Component;

use App\Models\Button;
use App\Models\Sale;
use App\Models\SaleImage;
use App\Models\SaleVideo;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;
use App\Models\Ad;

class SalesPageContent extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $ad_banner_w;
    public $ad_banner_h;

    public $card_title;
    public $page_title;
    public $title;
    public $username;
    public $user;
    public $fullname;
    public $favicon;
    public $event;
    public $videos;
    public $directions;
    public $images;
    public $video_count;
    public $image_count;
    public $showFooter;

    public $sale_page;

    //footer by user
    public ?string $footer_text;
    public ?string $footer_link;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    //Ads
    public $ads_top, $ads_bottom;
    public $getAds = false;

    public $user_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $is_active;

    public $condition;

    public $contacts;
    public $sale_id;
    public $payments;

    public function displaySalePage($username, $sale)
    {
        // get user creds
        $this->username = $username;
        $this->sale_id = $sale->id;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type', 'is_active']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;
            $this->is_active = $this->user->is_active;

            //if user exist, get contact points
            $this->contacts = Button::where($this->condition)
                ->where('is_active', true)
                ->where('view', 'contacts')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get payment links
            $this->payments = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'payments')
                ->orderBy('order', 'asc')
                ->get();

            // Check if sale page exist
            $this->sale_page = Sale::where('is_active', true)
                ->where('id', $sale->id)
                ->orderBy('order', 'asc')
                ->first();

            //if user exist, get videos
            $this->videos = SaleVideo::where('is_active', true)
                ->where('sales_id', $sale->id)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get direction links
            $this->directions = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'directions')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get images
            $this->images = SaleImage::where('is_active', true)
                ->where('sales_id', $sale->id)
                ->orderBy('order', 'asc')
                ->get();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Settings: Footer set by the user
            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            if ($this->contacts->isEmpty()) {
                $this->contacts = 0;
            }

            // if NULL, set to TRUE
            // $this->services_price_enabled = $this->services_price_enabled ?? true;
            $this->title = $this->sale_page->title ?? '';

            //if footer text and link not already set, set to true
            if ($this->footer_text == NULL && $this->footer_link == NULL) {
                $this->showFooter = true;
            }

            if ($this->footer_text && $this->footer_link) {
                $this->showFooter = true;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if ($this->directions->isEmpty()) {
                $this->directions = 0;
            }

            if ($this->payments->isEmpty()) {
                $this->payments = 0;
            }

            if (!$this->sale_page) {
                $this->sale_page = 0;
                $this->title = '';
                $this->card_title = "Event not found";
            }
        } else {
            $this->user = 0;
            $this->title = '';
            $this->card_title = "Event not found";
        }
    }

    public function __construct()
    {

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;

        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;
        $this->ad_banner_w = $default->ad_banner_w;
        $this->ad_banner_h = $default->ad_banner_h;
    }

    public function mount($username, Sale $sales)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        // $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        // if ($this->checkSub > 0) {
        //     $this->page_id = SubCard::where('username', $this->username)
        //         ->pluck('id')
        //         ->first();
        //     $this->mainCard = false;
        //     $this->condition = ['page_id' => $this->page_id];
        // }

        $this->getAds = true;

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';

        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->displaySalePage($username, $sales);

        if ($this->getAds && $this->is_active) {
            if ($this->user->user_type == 'Free') {
                // ads for free cards
                $this->ads_top = Ad::where('is_active', true)
                    ->where('position', 'top')
                    ->where('is_admin', true)
                    ->where('display_in', 'Free')
                    ->ordered()
                    ->get();

                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('position', 'bottom')
                    ->where('is_admin', true)
                    ->where('display_in', 'Free')
                    ->ordered()
                    ->get();
            }
            // Basic card who own ads
            else if ($this->user->user_type == "Basic") {
                // else if ($this->user_type == "Basic" && !$referred_id) {
                $this->ads_top = Ad::where('is_active', true)->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'top')
                    ->ordered()->get();

                $this->ads_bottom = Ad::where('is_active', true)->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'bottom')
                    ->ordered()->get();
            } else if ($this->user->user_type == "Sponsored") {
                // ads for sponsored card
                $this->ads_top = Ad::where('is_active', true)
                    ->where('position', 'top')
                    ->where('is_admin', true)
                    ->where('display_in', 'Sponsored')
                    ->where('sponsor_id', $this->sponsor_id)
                    ->ordered()
                    ->get();

                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('display_in', 'Sponsored')
                    ->where('sponsor_id', $this->sponsor_id)
                    ->where('position', 'bottom')
                    ->where('is_admin', true)
                    ->ordered()
                    ->get();
            } else if (in_array($this->user->user_type, ['Gold', 'Platinum']) && $this->mainCard) {
                // if user_type not free and main card
                // get all ads on position = top
                $this->ads_top = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'top')
                    ->ordered()
                    ->get();

                // get all ads on position = top
                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('position', 'bottom')
                    ->ordered()
                    ->get();
            } else {
                // if  sub card
                // get all ads on position = top
                $this->ads_top = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', $this->page_id)
                    ->where('position', 'top')
                    ->ordered()
                    ->get();

                // get all ads on position = top
                $this->ads_bottom = Ad::where('is_active', true)
                    ->where('is_admin', false)
                    ->where('user_id', $this->user->id)
                    ->where('page_id', $this->page_id)
                    ->where('position', 'bottom')
                    ->ordered()
                    ->get();
            }
        }
    }

    public function render()
    {
        $this->video_count = count($this->videos);
        $this->image_count = count($this->images);
        $thumbnail = $this->sale_page->thumbnail ?? $this->favicon;
        return view('livewire.sales-page-content')->title($this->title . '| ' . ($this->page_title ?? $this->card_title))->layoutData([
            'favicon' => $thumbnail,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'thumbnail' => $thumbnail,
            'ads_top' => $this->ads_top,
            'ads_bottom' => $this->ads_bottom,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'color_settings_custom_button_text' => $this->color_settings_custom_button_text,
            'color_settings_custom_button' => $this->color_settings_custom_button,
        ]);
    }
}
