<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class RegistrationSuccess extends Component
{
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $logo;
    public $mockup;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;
        $this->mockup = $default->mockup;
        $this->app_name = $default->app_name;

        // COMMENTED OUT: no more encrypted subscription data required
        /*
        $encrypted = $request->query('data');

        if (!$encrypted) {
            abort(403, 'Missing subscription data.');
        }

        try {
            $data = \Illuminate\Support\Facades\Crypt::decrypt($encrypted);
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::warning('RegistrationSuccess decrypt error', ['error' => $e->getMessage()]);
            abort(403, 'Invalid or tampered data.');
        }

        if (!is_array($data)) {
            abort(403, 'Invalid subscription data format.');
        }

        $validator = \Illuminate\Support\Facades\Validator::make($data, [
            'plan' => 'required|in:basic,basic_m,gold,gold_m,platinum,platinum_m',
            'user_id' => 'required|integer|exists:users,id',
        ]);

        if ($validator->fails()) {
            abort(422, 'Invalid subscription data.');
        }

        $this->plan = $data['plan'];
        $this->user_id = $data['user_id'];

        // Updating user_type should now be handled via central webhook
        $normalizedPlan = str_ends_with($this->plan, '_m') ? str_replace('_m', '', $this->plan) : $this->plan;
        */
    }

    public function render()
    {
        return view('livewire.registration-success')
            ->title('Welcome to ' . $this->site_name)
            ->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
