<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithFileUploads;

class RegistrationForm extends Component
{
    use WithFileUploads;

    public int $step = 1;

    // Step 1: Account Info
    public $email, $username, $password, $password_confirmation;

    // Step 2: Personal Info
    public $full_name, $birthdate, $gender, $phone, $location;

    // Step 3: Profile Picture
    public $profile_picture;

    public function nextStep()
    {
        $this->validateStep();
        $this->step++;
        dd('Next Step');
    }

    public function previousStep()
    {
        $this->step--;
    }

    public function submit()
    {
        $this->validateStep(finalStep: true);

        // Handle final submission logic here (save to DB, etc.)
        // Example: User::create([...])

        session()->flash('message', 'Registration complete!');
        return redirect()->route('home');
    }

    public function validateStep($finalStep = false)
    {
        $rules = [];

        if ($this->step === 1) {
            $rules = [
                'email' => 'required|email|unique:users,email',
                'username' => 'required|min:3|unique:users,username',
                'password' => 'required|min:6|same:password_confirmation',
            ];
        } elseif ($this->step === 2) {
            $rules = [
                'full_name' => 'required|string',
                'birthdate' => 'required|date',
                'gender' => 'nullable|string',
                'phone' => 'nullable|string',
                'location' => 'required|string',
            ];
        } elseif ($this->step === 3 || $finalStep) {
            $rules = [
                'profile_picture' => 'nullable|image|max:1024',
            ];
        }

        $this->validate($rules);
    }

    public function render()
    {
        return view('livewire.registration-form')->title('Registration');
    }
}
