<?php

namespace App\Livewire;

use App\Models\Commissions;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Livewire\WithPagination;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;

class ReferredPageInfo extends Component
{
    use WithPagination;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;
    public $affiliate_functionality;

    public $referred;
    public $commissions;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public $ref_firstname;
    public $ref_lastname;
    public $ref_fullname;

    public $is_subscribed;
    public $exist;
    public $user;

    public $checkMain, $page_id;

    public function mount($user_id)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
        $this->affiliate_functionality = $default->affiliate_functionality;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;

        $this->referredPageInfo($user_id);
    }

    public function referredPageInfo($user_id)
    {
        $this->user = auth()->user();

        if ($this->affiliate_functionality == false) {
            abort(403, 'Access denied.');
        }

        $this->checkMain = User::where('id', $this->user->id)->where('active_card', true)->exists();
        $this->referred = User::where('id', $user_id)->first();

        if ($this->checkMain) {

            $this->commissions = Commissions::where('user_id', $this->user->id)
                ->where('referred_id', $this->referred->id)
                ->where('amount', '>', 0) // 👈 filter out zero commissions
                ->orderBy('created_at', 'desc')
                ->get();
            $this->exist = User::where('id', $user_id)->exists();
        } else {
            $this->page_id = SubCard::where('user_id', $this->user->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->commissions = Commissions::where('page_id', $this->page_id)
                ->where('referred_id', $this->referred->id)
                ->where('amount', '>', 0) // 👈 filter out zero commissions
                ->orderBy('created_at', 'desc')
                ->get();

            $this->exist = SubCard::where('id', $this->page_id)->exists();
        }

        if ($this->exist) {
            $invoices = $this->referred->invoices() ?? collect();

            $this->commissions = $this->commissions->map(function ($commission) use ($invoices) {
                if ($commission->stripe_invoice_id) {
                    $invoice = collect($invoices)->first(function ($inv) use ($commission) {
                        return $inv->id == $commission->stripe_invoice_id;
                    });

                    $commission->stripe_invoice_total = $invoice?->total();
                    $commission->stripe_invoice_date = $invoice?->date();
                } else {
                    // When no stripe_invoice_id, just default to null
                    $commission->stripe_invoice_total = null;
                    $commission->stripe_invoice_date = null;
                }

                return $commission;
            });

            // Referred Info
            $this->ref_firstname = $this->referred['firstname'];
            $this->ref_lastname = $this->referred['lastname'];

            if ($this->ref_firstname && $this->ref_lastname) {
                $this->ref_fullname = "{$this->ref_firstname} {$this->ref_lastname}";
            } else {
                $this->ref_fullname = 'User #' . $this->referred['id'];
            }

            $this->is_subscribed = $this->referred->subscribed();
            // dd($this->is_subscribed);
        }
    }

    public function render()
    {
        return view(
            'livewire.referred-page-info'
        )
            ->title($this->exist ? $this->ref_fullname : 'Does not exist' . ' | ' . $this->site_name)->layoutData([
                'thumbnail' => $this->thumbnail,
                'app_name' => $this->app_name,
            ]);
    }
}
