<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductCollection;
use App\Models\SubCard;
use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class ProductSubscriptionPage extends Component
{
    use AuthorizesRequests;

    public $user;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $subscriptions;
    public $favicon;
    public $page_id; //subcard id, used in query

    public $card_title;
    public $fullname;
    public $condition;

    public $checkifactive;

    public function subscriptionProductManager()
    {
        // if active, get the datas and set to form
        if ($this->checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'thumbnail', 'user_type']);

            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.user_id', auth()->user()->id)
                ->where('subcards.active_card', true)
                ->first([
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.user_type',
                ]);

            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        $this->subscriptions = Product::where($this->condition)->where('type', 'subscription')->get();

        if ($this->user) {

            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            if ($this->subscriptions->isEmpty()) {
                $this->subscriptions = 0;
            }

            if ($this->checkifactive > 0) {
                // Card title
                $this->card_title = UserSettings::where('user_id', $this->user->id)
                    ->where('page_id', NULL)
                    ->where('setting_key', 'card_custom_title')
                    ->pluck('setting_value')
                    ->first();
            } else {
                // Card title
                $this->card_title = UserSettings::where('user_id', $this->user->id)
                    ->where('setting_key', 'card_custom_title')
                    ->where('page_id', $this->page_id)
                    ->pluck('setting_value')
                    ->first();
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->fullname = "Not found";
        }
    }

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->subscriptionProductManager();
    }

    public function render()
    {
        // Check if user is authorize
        // $this->authorize('view', Product::class);
        return view('livewire.product-subscription-page')->title('Subscriptions | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
            // 'favicon' => $this->favicon,
        ]);
    }
}
