<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class ProductImageField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $featured_image;

    #[On('setProductImage')]
    public function setProductImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditProductImage')]
    public function setProductImageEdit($featured_image)
    {
        $this->featured_image = $featured_image;
    }

    public function render()
    {
        return view('livewire.product-image-field');
    }
}
