<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class ProductCollectionImageField extends Component
{
    use WithFileUploads;

    public Model $model;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif,heic,avif|max:5120')]
    public $image;

    public ?string $croppedBlob;

    public $collection_banner;

    #[On('setBannerImage')]
    public function setBannerImage($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    #[On('setEditBannerImage')]
    public function setEditBannerEdit($collection_banner)
    {
        $this->collection_banner = $collection_banner;
    }

    public function render()
    {
        return view('livewire.product-collection-image-field');
    }
}
