<?php

namespace App\Livewire;

use App\Models\Ad;
use App\Models\Button;
use App\Models\Direction;
use Livewire\Component;
use App\Models\User;
use App\Models\UserSettings;
use App\Models\SubCard;
use App\Models\PageContent;
use App\Models\Sponsor;
use App\Models\Referral;
use App\Models\PresentationPage as presentation_page;
use App\Models\Social;
use App\Settings\CardDefaultsSetting;

class PresentationPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $affiliate_functionality;
    public $app_name;

    public $ad_banner_w;
    public $ad_banner_h;

    public $card_title;
    public $page_title;

    public $page;
    public $slug;
    public $contents;

    public $user;
    public $username;


    //Ads
    public $ads_top, $ads_bottom;

    // To display as SEO
    public $fullname;
    public $favicon;
    public $bio;

    public $customFooter = false;
    public $getAds = false;

    //check if card is active
    public $is_active;

    //check if card is searchable
    public $searchable;

    //profile layout
    public $profile_layout;

    public $socials;
    public $contacts;
    public $connect_icon;
    public $communities;
    public $directions;

    //colors
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $follow_text, $bio_text, $contact_text, $short_bio_enabled, $display_country;

    //for VCF
    public $firstname, $lastname, $email, $phone, $gender, $customLinks, $job_title, $company, $company_website, $vbc, $profile_pic, $cover_pic, $user_type, $sponsor_id;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $condition;
    public $query;

    public $referrer_username, $referral, $referrer_id;

    public $sponsor_username, $sponsor_user_id;

    public function displayPage($username, $slug)
    {
        $this->username = $username;
        $this->slug = $slug;

        // If user exist
        if ($this->user) {
            // main card

            if ($this->mainCard == true) {
                $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
                $this->query = ['user_id' => $this->user->id, 'page_id' => NULL];
            } else {
                // $this->condition = ['user_id' => $this->user->id, 'page_id' => $this->page_id];
                $this->condition = ['page_id' => $this->page_id];
                $this->query = ['page_id' => $this->page_id];
            }

            $this->page = presentation_page::where('is_active', true)
                ->where($this->condition)
                ->where('slug', $this->slug)
                ->first();

            //Settings: Check if card is searchable
            $this->searchable = UserSettings::where('setting_key', 'searchable')
                ->where($this->contacts)
                ->pluck('setting_value')
                ->first();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //profile layout
            $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //colors
            $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Background Color Settings
            $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Text Color Settings
            $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Follow text
            $this->follow_text = UserSettings::where('setting_key', 'follow_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Bio text
            $this->bio_text = UserSettings::where('setting_key', 'bio_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Contact text
            $this->contact_text = UserSettings::where('setting_key', 'contact_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //if user exist, get contact points
            $this->contacts = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'contacts')
                ->orderBy('order', 'asc')
                ->get();

            // Short Bio enabled
            $this->short_bio_enabled = UserSettings::where('setting_key', 'display_short_bio')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Country enabled
            $this->display_country = UserSettings::where('setting_key', 'display_country')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Let;s Connect Icon
            $this->connect_icon = UserSettings::where('setting_key', 'connect_icon')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //if user exist, get contact points
            $this->communities = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'communities')
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get direction links
            $this->directions = Direction::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            //if user exist, get socials
            $this->socials = Social::where('is_active', true)
                ->where($this->condition)
                ->orderBy('order', 'asc')
                ->get();

            if ($this->page == NULL) {
                abort(404, 'Page not found');
            }

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            $this->bio = $this->user->bio;

            // Set the fullanme
            $this->fullname = $this->firstname . ' ' . $this->lastname;
            //for VCF
            $this->email = $this->user->email;
            $this->job_title = $this->user->job_title;
            $this->phone = $this->user->phone;
            $this->gender = $this->user->gender;
            $this->vbc = $this->site_url . $this->user->username;
            $this->company = $this->user->company;

            //used only to determine the footer text and link
            $this->user_type = $this->user->user_type;

            //sponsor id
            $this->sponsor_id = $this->user->sponsor_id;

            $this->company_website = $this->user->company_website;

            $this->is_active = $this->user->is_active;

            $this->searchable = $this->searchable ?? true;

            $this->profile_layout = $this->profile_layout ?? 'default';

            // if NULL, set to TRUE
            $this->short_bio_enabled = $this->short_bio_enabled ?? true;

            $this->display_country = $this->display_country ?? true;

            if ($this->page->title) {
                $this->page_title = $this->page->title;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if ($this->contacts->isEmpty()) {
                $this->contacts = 0;
            }

            if ($this->communities->isEmpty()) {
                $this->communities = 0;
            }

            if ($this->directions->isEmpty()) {
                $this->directions = 0;
            }

            if ($this->socials->isEmpty()) {
                $this->socials = 0;
            }

            //colors
            // if no value, set default colors
            $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
            $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
            $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
            $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
            $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
            $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
            $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
            $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->page_title = "Not found";
            $this->fullname = "Not found";
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->ad_banner_w = $default->ad_banner_w;
        $this->ad_banner_h = $default->ad_banner_h;
        $this->affiliate_functionality = $default->affiliate_functionality;
        $this->app_name = $default->app_name;
    }

    public function mount($username, $slug)
    {

        $check = User::where('username', $username)->first()
            ?? SubCard::where('username', $username)->first();

        if (!$check) {

            abort(404, 'Page not found');
        }

        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->getAds = true;
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $username)
                ->where('is_active', true)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->getAds = true;
        }

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first([
                'id',
                'email',
                'phone',
                'profile_pic',
                'cover_pic',
                'thumbnail',
                'username',
                'firstname',
                'lastname',
                'job_title',
                'company',
                'company_website',
                'bio',
                'bio_long',
                'language',
                'address',
                'country',
                'user_type',
                'is_active',
                'sponsor_id'
            ]);

            if ($this->user) {
                $this->firstname = $this->user->firstname;
                $this->lastname = $this->user->lastname;
                $this->user_type = $this->user->user_type;
                $this->sponsor_id = $this->user->sponsor_id;
                $this->is_active = $this->user->is_active;
            } else {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];

            if ($this->user->user_type == 'Sponsored') {
                $this->sponsor_user_id = Sponsor::where('id', $this->sponsor_id)->where('is_active', true)->pluck('user_id')->first();
                $this->sponsor_username = User::where('id', $this->sponsor_user_id)->pluck('username')->first();
                if (!$this->sponsor_username) {
                    $this->sponsor_username = $this->username;
                }
            }
        }

        if ($this->checkSub > 0) {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.bio_long',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail',
                    'subcards.firstname as subcard_firstname',
                    'subcards.lastname as subcard_lastname',
                    'users.firstname as user_firstname',
                    'users.lastname as user_lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'users.id',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active'
                ]);

            if (!$this->user) {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->user_type = $this->user->user_type;
            $this->is_active = $this->user->is_active;

            // Handle fallback name if subcard firstname/lastname is missing
            $this->firstname = $this->user->subcard_firstname ?: $this->user->user_firstname;
            $this->lastname = $this->user->subcard_lastname ?: $this->user->user_lastname;

            $this->condition = ['page_id' => $this->page_id];
        }

        if ($this->user) {
            $this->referral = Referral::where('referred_id', $this->user->id)
                ->first();

            if ($this->referral) {
                if ($this->referral->referrer_id_main) {
                    $referrer = User::where('id', $this->referral->referrer_id_main)->first();
                    $this->referrer_username = $referrer->username;
                    $this->referrer_id = $referrer->id;
                    $ad_query = ['user_id' => $this->referrer_id, 'page_id' => NULL];
                } else {
                    $referrer = SubCard::where('id', $this->referral->referrer_id_sub)->first();
                    $this->referrer_username = $referrer->username;
                    $this->referrer_id = $referrer->id;
                    // dd($this->referrer_username, $this->referrer_id);
                    $ad_query =  ['page_id' => $this->referrer_id];
                }
            }

            if ($this->getAds && $this->is_active) {
                if ($this->user_type == 'Free' && !$this->referral) {
                    // ads for free cards
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('position', 'top')
                        ->where('is_admin', true)
                        ->where('display_in', 'Free')
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('position', 'bottom')
                        ->where('is_admin', true)
                        ->where('display_in', 'Free')
                        ->ordered()
                        ->get();
                } elseif ($this->user_type == 'Free' && $this->referral) {

                    $this->ads_top = Ad::where('is_active', true)
                        ->where($ad_query)
                        ->where('position', 'top')
                        ->where('is_admin', false)
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('position', 'bottom')
                        ->where($ad_query)
                        ->where('is_admin', false)
                        ->ordered()
                        ->get();
                }

                // Basic card who own ads
                else if ($this->user_type == "Basic") {
                    // else if ($this->user_type == "Basic" && !$referred_id) {
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()->get();
                } else if ($this->user_type == "Sponsored") {
                    // ads for sponsored card
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('position', 'top')
                        ->where('is_admin', true)
                        ->where('display_in', 'Sponsored')
                        ->where('sponsor_id', $this->sponsor_id)
                        ->ordered()
                        ->get();

                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('display_in', 'Sponsored')
                        ->where('sponsor_id', $this->sponsor_id)
                        ->where('position', 'bottom')
                        ->where('is_admin', true)
                        ->ordered()
                        ->get();
                } else if (in_array($this->user_type, ['Gold', 'Platinum']) && $this->mainCard) {
                    // if user_type not free and main card
                    // get all ads on position = top
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()
                        ->get();

                    // get all ads on position = top
                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()
                        ->get();
                } else {
                    // if  sub card
                    // get all ads on position = top
                    $this->ads_top = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'top')
                        ->ordered()
                        ->get();


                    // get all ads on position = top
                    $this->ads_bottom = Ad::where('is_active', true)
                        ->where('is_admin', false)
                        ->where($this->condition)
                        ->where('position', 'bottom')
                        ->ordered()
                        ->get();
                }
            }
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->page_title = "Not found";
            $this->fullname = "Not found";
        }

        $this->displayPage($username, $slug);
    }

    public function render()
    {
        return view('livewire.presentation-page')->title('' . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'username' => $this->username,
            'bio' => $this->bio,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'site_url' => $this->site_url,
            'ads_top' => $this->ads_top,
            'ads_bottom' => $this->ads_bottom,
            'thumbnail' => $this->thumbnail,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'app_name' => $this->app_name,
        ]);
    }
}
