<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class PhysicalCardField extends Component
{
    use WithFileUploads;

    public Model $model;
    // public $title = 'Event Poster';
    public $image;
    public ?string $croppedBlob;
    public $physical_card;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    #[On('setPhysicalCard')]
    public function setPhysicalCard($croppedBlob)
    {
        $this->croppedBlob = $croppedBlob;
    }

    public function render()
    {
        return view('livewire.physical-card-field');
    }
}
