<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Livewire\Attributes\Validate;
use Livewire\Attributes\On;
use Illuminate\Database\Eloquent\Model;

class PhysicalCardBackField extends Component
{
    use WithFileUploads;

    public Model $model;
    public $image;
    public ?string $croppedBlob_back;
    public $physical_card;

    #[Validate('image|mimes:jpeg,png,jpg,webp,heif|max:5120')]

    #[On('setPhysicalCardBack')]
    public function setPhysicalCardBack($croppedBlob)
    {
        $this->croppedBlob_back = $croppedBlob;
        // dd($this->croppedBlob);
    }

    public function render()
    {
        return view('livewire.physical-card-back-field');
    }
}
