<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\User;
use App\Models\UserSettings;
use App\Models\SubCard;
use App\Models\Button;
use App\Settings\CardDefaultsSetting;

class PaymentPage extends Component
{
    // Site Settings
    public $site_url;
    public $app_name;
    public $site_name;
    public $thumbnail;
    public $card_title;
    public $page_title;
    public $username;
    public $payments;

    public $user;

    // To display as SEO
    public $fullname;
    public $favicon;
    public $bio;

    //check if card is active
    public $is_active;

    //check if card is searchable
    public $searchable;

    //check if country display is enabled
    public $display_country;

    //short bio
    public $short_bio_enabled;

    //username
    public $username_enabled;

    //profile layout
    public $profile_layout;


    //colors
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    //style
    public $button_style;

    //for VCF
    public $firstname, $lastname, $email, $phone, $gender, $customLinks, $job_title, $company, $company_website, $vbc, $profile_pic, $cover_pic, $user_type, $sponsor_id;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;
    public $condition;

    public function displayCard($username)
    {
        // get user creds
        $this->username = $username;

        // If user exist
        if ($this->user) {
            // main card

            //Settings: Check if card is searchable
            $this->searchable = UserSettings::where('setting_key', 'searchable')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Country enabled
            $this->display_country = UserSettings::where('setting_key', 'display_country')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //if user exist, get payment links
            $this->payments = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'payments')
                ->orderBy('order', 'asc')
                ->get();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();


            // Short Bio enabled
            $this->short_bio_enabled = UserSettings::where('setting_key', 'display_short_bio')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //username
            $this->username_enabled = UserSettings::where('setting_key', 'display_username')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //profile layout
            $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //colors
            $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Background Color Settings
            $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Text Color Settings
            $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->button_style = UserSettings::where('setting_key', 'button_style')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            $this->bio = $this->user->bio;

            // Set the fullanme
            $this->fullname = $this->firstname . ' ' . $this->lastname;
            //for VCF
            $this->email = $this->user->email;
            $this->job_title = $this->user->job_title;
            $this->phone = $this->user->phone;
            $this->gender = $this->user->gender;
            // $this->vbc = $this->site_url . 'card/' . $this->user->username;
            $this->vbc = $this->site_url . $this->user->username;
            $this->company = $this->user->company;

            //used only to determine the footer text and link
            $this->user_type = $this->user->user_type;

            //sponsor id
            $this->sponsor_id = $this->user->sponsor_id;

            $this->company_website = $this->user->company_website;

            $this->is_active = $this->user->is_active;

            $this->searchable = $this->searchable ?? true;

            $this->display_country = $this->display_country ?? true;

            // if NULL, set to TRUE
            $this->short_bio_enabled = $this->short_bio_enabled ?? true;

            // if NULL, set to TRUE
            $this->username_enabled = $this->username_enabled ?? true;

            $this->profile_layout = $this->profile_layout ?? 'default';

            if ($this->payments->isEmpty()) {
                abort(404, 'Page not found.');
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            //colors
            // if no value, set default colors
            $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
            $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
            $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
            $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
            $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
            $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
            $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
            $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';

            //style
            $this->button_style = $this->button_style ?: 'rounded';
        } else {
            $this->user = 0;
            $this->card_title = "Not found";
            $this->page_title = "Not found";
            $this->fullname = "Not found";
        }
    }


    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->app_name = $default->app_name;
        $this->thumbnail = $default->thumbnail;
    }

    public function mount($username)
    {
        $this->username = $username;

        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $username)
                ->where('is_active', true)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
        }

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first([
                'id',
                'email',
                'phone',
                'profile_pic',
                'cover_pic',
                'thumbnail',
                'username',
                'firstname',
                'lastname',
                'job_title',
                'company',
                'company_website',
                'bio',
                'bio_long',
                'language',
                'address',
                'country',
                'state',
                'user_type',
                'is_active',
                'sponsor_id'
            ]);

            if ($this->user) {
                $this->firstname = $this->user->firstname;
                $this->lastname = $this->user->lastname;
                $this->user_type = $this->user->user_type;
                $this->sponsor_id = $this->user->sponsor_id;
                $this->is_active = $this->user->is_active;
            } else {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.bio_long',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail',
                    'subcards.firstname as subcard_firstname',
                    'subcards.lastname as subcard_lastname',
                    'users.firstname as user_firstname',
                    'users.lastname as user_lastname',
                    'users.address',
                    'users.country',
                    'users.state',
                    'users.user_type',
                    'users.id',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active'
                ]);

            if (!$this->user) {
                $this->user = 0;
                $this->card_title = "Not found";
                $this->page_title = "Not found";
                $this->fullname = "Not found";
                return;
            }

            $this->user_type = $this->user->user_type;
            $this->is_active = $this->user->is_active;

            // Handle fallback name if subcard firstname/lastname is missing
            $this->firstname = $this->user->subcard_firstname ?: $this->user->user_firstname;
            $this->lastname = $this->user->subcard_lastname ?: $this->user->user_lastname;

            $this->condition = ['page_id' => $this->page_id];
        }


        $this->displayCard($username);
    }

    public function render()
    {
        return view('livewire.payment-page')->title('Payments | ' . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'username' => $this->username,
            'bio' => $this->bio,
            'firstname' => $this->firstname,
            'lastname' => $this->lastname,
            'site_url' => $this->site_url,
            'app_name' => $this->app_name,
            'thumbnail' => $this->thumbnail,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'button_style' => $this->button_style,
        ]);
    }
}
