<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Models\Partnership;

class PartnershipProgramSelection extends Component
{
    use AuthorizesRequests;

    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $current_card;
    public $logo;
    public $mockup;
    public $manual_capture_mode;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;
        $this->app_name = $default->app_name;
        $this->mockup = $default->mockup;

        $this->manual_capture_mode = $default->manual_capture_mode;

        $this->current_card = auth()->user()->user_type;
    }

    public function render()
    {
        $this->authorize('view', Partnership::class);
        return view('livewire.partnership-program-selection')->title('Partnership Program | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
