<?php

namespace App\Livewire;

use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class PartnershipDashboard extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $term_basic;
    public $term_gold;
    public $term_platinum;

    public $user;
    public $card_title;
    public $condition;

    public $plan_id;

    public $basic_card;
    public $gold_card;
    public $platinum_card;
    public $is_test_mode;

    public $new_user_type;

    public $current_period_end;
    public $current_period_start;

    public function mount()
    {
        $this->profileSettings();
    }

    public function profileSettings()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'profile_pic', 'firstname', 'lastname', 'user_type', 'partnership_level']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->first(['username', 'firstname', 'lastname', 'profile_pic']);
            $this->condition = ['page_id' => $this->user->id];
        }

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        //Terms
        $this->term_basic = $default->term_basic;
        $this->term_gold = $default->term_gold;
        $this->term_platinum = $default->term_platinum;

        return view('livewire.partnership-dashboard')->title('Partnership Program | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
