<?php

namespace App\Livewire;

use App\Models\Partnership;
use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Settings\CardDefaultsSetting;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class PartnershipCheckoutManual extends Component
{
    use WithFileUploads;
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $card_title;
    public $page_title;
    public $logo;

    public $user;
    public $fullname;
    public $favicon;

    public $site_button_color;
    public $site_button_text_color;

    public $condition;
    public $selected_plan;
    public $selected_plan_text;
    public $term_description;
    public $price;
    public $price_link;
    public $page_id;

    public $receipt;
    public $checkifactive;

    public function mount()
    {
        $this->checkifactive = User::where('id', auth()->id())
            ->where('active_card', true)->count();

        if ($this->checkifactive < 1) {
            $this->page_id = SubCard::where('user_id', auth()->id())
                ->where('active_card', true)
                ->value('id')
                ->first();
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->app_name = $default->app_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;

        $this->site_button_text_color = $default->site_button_text_color;
        $this->site_button_color = $default->site_button_color;

        $this->site_button_text_color = $this->site_button_text_color ?: '#000';
        $this->site_button_color = $this->site_button_color ?: '#facc15';

        $this->selected_plan = request()->query('selected_plan');

        if (!in_array($this->selected_plan, ['junior', 'senior']) && $default->manual_capture_mode) {
            abort(404, 'Invalid plan.');
        }

        if ($this->selected_plan == 'junior' && in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum'])) {
            $this->selected_plan_text = "Junior Program";
            $this->term_description = $default->term_description_junior_partner;
            $this->price_link = $default->manual_junior_partnership_link;
            $this->price = '2500';
        } else if ($this->selected_plan == 'senior' && in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum'])) {
            $this->selected_plan_text = "Senior Program";
            $this->term_description = $default->term_description_senior_partner;
            $this->price_link = $default->manual_senior_partnership_link;
            $this->price = '5000';
        } else {
            abort(403, 'Invalid access');
        }
    }

    public function requestUpgradeCard()
    {
        $validated = $this->validate(
            [
                'receipt'     => 'required|image|mimes:jpeg,jpg,png,webp|max:5120',
            ]
        );

        $validated['user_id'] = auth()->id();
        $validated['page_id'] = $this->page_id;
        $validated['old_partnership'] = auth()->user()->partnership_level;
        $validated['requested_partnership'] = $this->selected_plan;

        if ($this->receipt) {
            $validated['receipt'] =  $this->receipt->storePublicly('receipts', 'public');
        }

        try {
            $create = Partnership::create($validated);

            if ($create) {
                session()->flash('success', 'Request send. Thank you.');
            } else {
                session()->flash('error', 'Error submitting the form.');
            }
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }

        return $this->redirect('/dashboard', navigate: true);
    }

    public function render()
    {
        $this->authorize('view', Partnership::class);
        return view('livewire.partnership-checkout-manual')->title("Partnership Program | " . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'thumbnail' => $this->thumbnail,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'site_button_text_color' => $this->site_button_text_color,
            'site_button_color' => $this->site_button_color,
            'app_name' => $this->app_name,
        ]);
    }
}
