<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Image;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;
use App\Models\Video;

class NewVideosComponent extends Component
{
    public $images;

    public $user_id;
    public $checkMain;
    public bool $mainCard = false;
    public $user;

    public $color_settings_profile_pic_border, $color_settings_custom_button_text, $color_settings_custom_button;
    public $condition;
    public $videos, $video_count;
    public $showOnlyFirstVideo = false;

    //style
    public $button_style;

    public function mount($username)
    {
        $checkifactive = User::where('username', $username)->count();

        if ($checkifactive > 0) {

            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->user = User::where('username', $username)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('username', $username)->first();
            $this->condition = ['page_id' => $this->user->id];
        }

        $this->videos =  Video::where($this->condition)->ordered()->where('is_active', true)->get();
        $this->video_count =  Video::where($this->condition)->ordered()->where('is_active', true)->count();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        //style
        $this->button_style = $this->button_style ?: 'rounded';
    }

    public function render()
    {
        return view('livewire.new-videos-component');
    }
}
