<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Image;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;

class GalleryComponent extends Component
{
    public $images;

    public $user_id;
    public $checkMain;
    public bool $mainCard = false;
    public $user;

    public $color_settings_profile_pic_border;
    public $gallery_two_slide;
    public $condition;

    public function mount($username)
    {
        $checkifactive = User::where('username', $username)->count();

        if ($checkifactive > 0) {
            // dd($checkifactive);

            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->user = User::where('username', $username)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('username', $username)->first();
            $this->condition = ['page_id' => $this->user->id];
        }

        $this->images =  Image::where($this->condition)->ordered()->where('is_active', true)->get();
        // dd($this->images, $this->condition, $username);
        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->gallery_two_slide = UserSettings::where('setting_key', 'gallery_two_slide')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
    }

    public function render()
    {
        // dd($this->gallery_two_slide);
        return view('livewire.gallery-component');
    }
}
