<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;
use App\Settings\CardDefaultsSetting;

class Footer extends Component
{
    public $user_type;
    public $default_ads_enabled;
    public $ad_items;

    public function mount()
    {
        $this->getUserType();

        $default = app(CardDefaultsSetting::class);

        $this->default_ads_enabled = $default->default_ads_enabled;
        // $this->ad_items = $default->ad_items;

        $this->ad_items = collect($default->ad_items)
            ->filter(fn($item) => isset($item['is_active']) && $item['is_active'])
            ->values() // reset array keys
            ->toArray();
    }

    public function getUserType()
    {
        $this->user_type = User::where('id', auth()->user()->id)->pluck('user_type')->first();
    }

    public function render()
    {
        return view('components.footer');
    }
}
