<?php

namespace App\Livewire;

use App\Models\FeedbackForm as feedback_form;
use Livewire\Component;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;
use Livewire\Attributes\On;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class FeedbackForm extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $card_title;
    public $page_title;

    public $user;
    public $fullname;
    public $favicon;
    public $contacts;

    public $customFooter = false;

    //footer by user
    public ?bool $footer_enabled;

    public ?string $footer_text;
    public ?string $footer_link;

    //footer by user
    public ?string $default_footer_text;
    public ?string $default_footer_link;

    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $user_id;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_profile_pic_border;
    public $color_settings_link;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public $condition;

    public $username, $firstname, $lastname, $phone, $profile_pic, $feedback, $email;

    #[On('profilePic')]
    public function setProfilePic($profileImageUrl)
    {
        $this->profile_pic = new TemporaryUploadedFile($profileImageUrl, config('filesystems.default'));
    }

    public function displayCard($username)
    {
        // get user creds
        $this->username = $username;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'language', 'address', 'country', 'id', 'user_type']);
        } else {
            $this->user = SubCard::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'id']);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            if ($this->mainCard == true) {
                $query = ['user_id' => $this->user->id, 'page_id' => NULL];
            } else {
                // $query = ['user_id' => NULL, 'page_id' => $this->page_id];
                $query = ['page_id' => $this->page_id];
            }

            //Settings: Footer set by the user
            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($query)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($query)
                ->pluck('setting_value')
                ->first();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($query)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($query)
                ->pluck('setting_value')
                ->first();

            // Footer enabled
            $this->footer_enabled = UserSettings::where('setting_key', 'footer_enabled')
                ->where($query)
                ->pluck('setting_value')
                ->first();

            //if user exist, get contact points
            $this->contacts = $this->user->buttons()->where('is_active', true)
                ->where('view', 'contacts')
                ->where($query)
                ->orderBy('order', 'asc')
                ->get();

            $this->footer_enabled = $this->footer_enabled ?? true;

            if ($this->footer_text && $this->footer_link) {
                $this->customFooter = true;
            }

            if ($this->contacts->isEmpty()) {
                $this->contacts = 0;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }
        } else {
            $this->user = 0;
        }
    }

    public function mount($username)
    {

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
        $this->default_footer_text = $default->footer_text;
        $this->default_footer_link = $default->footer_link;

        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->mainCard = false;
            $this->page_id = SubCard::where('username', $username)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->username = $username; // Set $this->username here
        $this->displayCard($this->username);


        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function feedbackForm()
    {
        // dd($this->condition, $this->checkMain, $this->username);
        $validated = $this->validate(
            [
                'firstname' => 'required|string|max:50',
                'lastname' => 'required|string|max:50',
                'phone' => 'required|regex:/^[\d\s\-\+\(\)]+$/|max:20',
                'email' => 'required|email:filter',
                'profile_pic' => 'nullable|image|mimes:jpeg,jpg,png,webp|max:5120',
                'feedback' => 'required|string|max:500',
            ],
            [
                'phone.regex' => 'Please enter a valid phone number.',
            ]
        );

        // --- Handle profile picture upload ---
        if ($this->profile_pic) {
            $validated['profile_pic'] = $this->profile_pic->storePublicly('profile_pic', 'public');

            $tempFilePath = $this->profile_pic->getRealPath();
            if (file_exists($tempFilePath)) {
                unlink($tempFilePath);
            }
        }

        try {
            $form = new \App\Models\FeedbackForm();

            // Assign validated fields
            $form->firstname = $validated['firstname'];
            $form->lastname = $validated['lastname'];
            $form->phone = $validated['phone'];
            $form->email = $validated['email'];
            $form->profile_pic = $validated['profile_pic'] ?? null;
            $form->feedback = $validated['feedback'];

            $form->fill($this->condition);

            // Save now
            $form->save();

            session()->flash('success', 'Thanks your for feedback!');
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }

        return $this->redirect($this->site_url . $this->username, navigate: true);
    }

    public function render()
    {
        return view('livewire.feedback-form')->title("Give us your feedback!  | " . ($this->page_title ?: $this->card_title))->layoutData([
            'favicon' => $this->favicon,
            'username' => $this->username,
            'thumbnail' => $this->thumbnail,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'app_name' => $this->app_name,
        ]);
    }
}
