<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\Auth;

class EmailVerified extends Component
{
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;
    public $logo;
    public $mockup;

    public function resendVerification()
    {
        if (Auth::user()) {
            Auth::user()->sendEmailVerificationNotification();
            session()->flash('success', 'Verification link sent!');
            return redirect()->route('verification.notice');
        }
    }

    public function mount()
    {
        if (auth()->user()->hasVerifiedEmail() && !auth()->user()->is_admin) {
            return redirect()->route('dashboard.index');
        }

        if (!auth()->user()->hasVerifiedEmail() && auth()->user()->is_admin) {
            return redirect('/admin');
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->logo = $default->logo;
        $this->mockup = $default->mockup;
        $this->app_name = $default->app_name;
    }

    public function render()
    {
        return view('livewire.email-verified')->title('Verify Email | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
