<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SaleVideo;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;

class EditSalesVideo extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;

    // Video data
    public SaleVideo $video;   // 👈 match the {video} route param
    public $product_name, $description, $video_link, $stock, $price;
    public $shop_online_link;
    public $shop_online_button;
    public $is_active;
    public $sales_id;

    public function mount(SaleVideo $video)
    {
        $this->video = $video;
        $this->sales_id = $video->sales_id;

        // Site defaults
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;

        // Fill form fields
        $this->product_name = $video->product_name;
        $this->description = $video->description;
        $this->stock = $video->stock;
        $this->price = $video->price;
        $this->video_link = $video->video_link;
        $this->shop_online_button = $video->shop_online_button;
        $this->shop_online_link = $video->shop_online_link;
        $this->is_active = $video->is_active;
    }

    public function saveVideo()
    {
        $validated = $this->validate([
            'product_name'       => 'required|string|max:100',
            'description'        => 'nullable|string|max:300',
            'stock'              => 'required|numeric',
            'price'              => 'required|numeric',
            'video_link'         => 'required|url',
            'shop_online_button' => 'nullable|string',
            'shop_online_link'   => 'required|url',
            'is_active'          => 'required|boolean',
        ]);

        if (!$validated['shop_online_button']) {
            $validated['shop_online_button'] = 'Shop';
        }

        $this->video->update($validated);

        session()->flash('success', 'Video successfully updated!');

        return $this->redirectRoute('sales.edit', [
            'id' => $this->sales_id,
        ], navigate: true);
    }

    public function render()
    {
        return view('livewire.edit-sales-video')
            ->title('Edit Video | ' . $this->site_name)
            ->layoutData([
                'thumbnail' => $this->thumbnail,
            ]);
    }
}
