<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Video;
use App\Models\User;
use App\Models\SubCard;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use App\Models\Review;
use Illuminate\Validation\ValidationException;

class EditReviewVideo extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $old_thumbnail;
    public $app_name;

    public $title, $video_link, $review_text, $cta_text, $cta_link;

    public $videoId, $video;
    public $condition, $page_id;

    protected $rules = [
        'title'             => 'required|string',
        'video_link'        => 'required|url',
        'review_text'       => 'nullable|string|max:2000',
        'cta_text'          => 'nullable|string',
        'cta_link'          => 'nullable|url',
    ];

    public function updateTestimonialVideo()
    {
        try {
            $this->validate();

            $updateData = [
                'title'             => $this->title,
                'video_link'        => $this->video_link,
                'review_text'       => $this->review_text,
                'cta_text'          => $this->cta_text,
                'cta_link'          => $this->cta_link,
            ];

            // Update the user's video
            $updateVideo = Review::where('id', $this->videoId)->update($updateData);
            if ($updateVideo) {
                session()->flash('success', 'Testimonial video successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }

        return $this->redirect('/dashboard/testimonial', navigate: true);
    }

    public function viewVideo($id)
    {
        $this->video = Review::where($this->condition)
            ->where('id', $id)
            ->select('id', 'title', 'video_link', 'review_text', 'cta_text', 'cta_link')
            ->first();

        if (!$this->video) {
            abort(403, 'Access denied');
        }
    }

    public function mount($id)
    {
        $this->videoId = $id;

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->viewVideo($this->videoId);

        if ($this->video) {
            $this->title            = $this->video->title;
            $this->video_link       = $this->video->video_link;
            $this->review_text      = $this->video->review_text;
            $this->cta_text         = $this->video->cta_text;
            $this->cta_link         = $this->video->cta_link;
        } else {
            abort(404, 'Page not found.');
        }

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;
    }

    public function render()
    {
        // $this->authorize('update', Video::class);
        return view('livewire.edit-review-video')->title('Update Testimonial Video | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
