<?php

namespace App\Livewire;

use App\Models\Direction;
use App\Models\User;
use App\Models\SubCard;
use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class EditDirectionLink extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $direction, $address, $google_map, $apple_map, $waze, $page_id, $direction_id, $condition;

    public function viewDirectionLink($id)
    {
        $this->direction = Direction::where($this->condition)
            ->where('id', $id)
            ->first();

        // if (!$this->direction) {
        //     abort(403, 'Access denied');
        // }
    }

    public function mount($id)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->direction_id = $id;
        $this->viewDirectionLink($this->direction_id);
        $this->address = $this->direction->address;
        $this->google_map = $this->direction->google_map;
        $this->apple_map = $this->direction->apple_map;
        $this->waze = $this->direction->waze;
    }

    public function updateDirectionLink()
    {
        try {
            $validated = $this->validate([
                'address' => 'required|string',
                'google_map' => 'nullable|url',
                'apple_map' => 'nullable|url',
                'waze' => 'nullable|url',
            ]);

            $checkifactive = User::where('id', auth()->user()->id)
                ->where('active_card', true)->count();

            //if maincard is not active
            if ($checkifactive < 1) {
                $this->page_id = SubCard::where('user_id', auth()->user()->id)
                    ->where('active_card', true)
                    ->pluck('id')
                    ->first();

                $this->condition = ['page_id' => $this->page_id];
            } else {
                $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
            }

            try {
                $update = Direction::where('id', $this->direction_id)->where($this->condition)->update($validated);
            } catch (\Exception $e) {
                session()->flash('error', $e->getMessage());
                return redirect()->back();
            }

            if ($update) {
                session()->flash('success', 'Direction link successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/directions', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }

    public function render()
    {
        // $this->authorize('create', Button::class);
        return view('livewire.edit-direction-link')->title('Edit Direction Link | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
