<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\Button;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;
use App\Settings\CardDefaultsSetting;
use Illuminate\Validation\ValidationException;

class EditCommunityLink extends Component
{
    use AuthorizesRequests;

    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $community, $title, $link, $type;
    public $community_id;

    public function updateCommunityLink()
    {
        try {
            $validated = $this->validate([
                'title' => 'required|string',
                'link' => 'required|url',
                'type' => 'required|in:fb_community,whatsapp_community,discord_community,telegram_community,skool_community',
            ]);

            // Update the user's community
            $update = Button::where('id', $this->community_id)->update($validated);

            if ($update) {
                session()->flash('success', 'Community Link successfully updated!');
            } else {
                session()->flash('error', 'Unauthorized action.');
            }

            return $this->redirect('/dashboard/communities', navigate: true);
        } catch (ValidationException $e) {
            // stop spinner on validation errors
            $this->dispatch('set-submitting', ['value' => false]);
            throw $e;
        }
    }


    public function viewCommunity($id)
    {
        $this->community = Button::where('user_id', auth()->user()->id)
            ->where('id', $id)
            ->whereIn('type', [
                'fb_community',
                'whatsapp_community',
                'discord_community',
                'telegram_community',
                'skool_community'
            ])
            ->select('id', 'title', 'link', 'type')
            ->first();

        if (!$this->community) {
            abort(403, 'Access denied');
        }
    }

    public function mount($id)
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->community_id = $id;
        $this->viewCommunity($this->community_id);
        $this->title = $this->community->title;
        $this->type = $this->community->type;
        $this->link = $this->community->link;
    }

    public function render()
    {
        // $this->authorize('update', Product::class);
        return view('livewire.edit-community-link')->title('Edit Community Link | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
