<?php

namespace App\Livewire;

use App\Models\Direction;
use App\Models\SubCard;
use App\Models\User;
use Livewire\Component;
use App\Models\UserSettings;

class DrivingDirectionModal extends Component
{
    public $user, $username, $directions, $checkMain, $checkSub, $page_id, $condition;
    public $color_settings_profile_pic_border, $color_settings_link;

    public function mount($username)
    {
        $this->username = $username;

        $this->checkMain = User::where('username', $username)->count();
        $this->checkSub = SubCard::where('username', $username)->count();

        if ($this->checkMain > 0) {
            $this->user = User::where('username', $username)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $username)
                ->where('is_active', true)
                ->pluck('id')
                ->first();
            $this->condition = ['page_id' =>  $this->page_id];
        }

        $this->directions = Direction::where('is_active', true)
            ->where($this->condition)
            ->orderBy('order', 'asc')
            ->get();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
    }

    public function render()
    {
        return view('livewire.driving-direction-modal');
    }
}
