<?php

namespace App\Livewire;

use Livewire\Component;

use App\Models\Button;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;
use App\Models\Product;
use App\Models\Review;

class DisplayReviews extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $card_title;
    public $page_title;
    public $event_title;
    public $username;
    public $user;
    public $fullname;
    public $favicon;
    public $video_count;
    public $reviews;

    public $showFooter;
    //profile layout
    public $profile_layout;

    //footer by user
    public ?string $footer_text;
    public ?string $footer_link;


    public $checkMain;
    public $checkSub;
    public bool $mainCard = false;
    public $page_id;

    public $user_id;

    public $color_settings_profile_pic_border;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;
    public $color_settings_link;

    //style
    public $button_style;

    public $is_active;

    public $condition;

    public $products;
    public $username_enabled;
    public $short_bio_enabled;
    public $display_country;
    public $reviews_page_title;

    public function displayReviews($username)
    {
        // get user creds
        $this->username = $username;

        if ($this->mainCard == true) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first(['email', 'phone', 'profile_pic', 'cover_pic', 'thumbnail', 'username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'language', 'address', 'country', 'id', 'user_type', 'is_active']);
        } else {
            $this->user = SubCard::join('users', 'subcards.user_id', '=', 'users.id')
                ->where('subcards.username', $this->username)
                ->first([
                    'subcards.id',
                    'subcards.user_id',
                    'subcards.username',
                    'subcards.job_title',
                    'subcards.company',
                    'subcards.company_website',
                    'subcards.bio',
                    'subcards.profile_pic',
                    'subcards.cover_pic',
                    'subcards.thumbnail',
                    'users.firstname',
                    'users.lastname',
                    'users.address',
                    'users.country',
                    'users.user_type',
                    'subcards.email',
                    'subcards.phone',
                    'subcards.is_active',
                    'users.id',
                ]);
        }

        if (!isset($this->username)) {
            $this->user = 0;
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;
            $this->is_active = $this->user->is_active;

            //if user exist, get contact points
            $this->reviews = Review::where($this->condition)
                ->where('is_active', true)
                ->orderBy('order', 'asc')
                ->get();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //Settings: Footer set by the user
            $this->footer_text = UserSettings::where('setting_key', 'footer_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->footer_link = UserSettings::where('setting_key', 'footer_link')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->reviews_page_title =  Button::where('type', 'reviews')
                ->where($this->condition)
                ->pluck('title')
                ->first();

            //if footer text and link not already set, set to true
            if ($this->footer_text == NULL && $this->footer_link == NULL) {
                $this->showFooter = true;
            }

            if ($this->footer_text && $this->footer_link) {
                $this->showFooter = true;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if ($this->reviews->isEmpty()) {
                // $this->event = 0;
                abort(404, 'Page not found.');
            }
        } else {
            abort(404, 'Page not found.');
        }
    }

    public function __construct()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
    }

    public function mount($username)
    {
        //used to determine where to check if the username exist
        $this->checkMain = User::where('username', $this->username)->count();
        $this->checkSub = SubCard::where('username', $this->username)->count();

        if ($this->checkMain > 0) {
            $this->mainCard = true;
            $this->user_id = User::where('username', $username)->where('is_active', true)->pluck('id')->first();
            $this->condition = ['user_id' => $this->user_id, 'page_id' => NULL];
        }

        if ($this->checkSub > 0) {
            $this->page_id = SubCard::where('username', $this->username)
                ->pluck('id')
                ->first();
            $this->mainCard = false;
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->products = Product::where($this->condition)
            ->where('is_active', true)
            ->get();

        //profile layout
        $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        //username
        $this->username_enabled = UserSettings::where('setting_key', 'display_username')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Short Bio enabled
        $this->short_bio_enabled = UserSettings::where('setting_key', 'display_short_bio')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->display_country = UserSettings::where('setting_key', 'display_country')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->button_style = UserSettings::where('setting_key', 'button_style')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->profile_layout = $this->profile_layout ?? 'default';
        $this->username_enabled = $this->username_enabled ?? true;
        $this->short_bio_enabled = $this->short_bio_enabled ?? true;
        $this->display_country = $this->display_country ?? true;
        //style
        $this->button_style = $this->button_style ?: 'rounded';

        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->site_url = $default->site_url;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->displayReviews($username);
    }

    public function render()
    {
        // dd($this->reviews);
        return view('livewire.display-reviews')->title($this->reviews_page_title . ' | ' . ($this->page_title ?? $this->card_title))->layoutData([
            'favicon' => $this->thumbnail,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
            'color_settings_profile_pic_border' => $this->color_settings_profile_pic_border,
            'app_name' => $this->app_name,
        ]);
    }
}
