<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class CustomizeColors extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $page_id; //subcard id, used in query
    public $checkifactive;
    public $condition;

    public $selected_color_setting;
    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_link;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        $this->checkifactive = User::where('id', auth()->user()->id)->where('active_card', true)->count();

        if ($this->checkifactive > 0) {
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->page_id = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('id')
                ->first();
            // $this->condition = ['user_id' => NULL, 'page_id' => $this->page_id];
            $this->condition = ['page_id' => $this->page_id];
        }

        $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_link = UserSettings::where('setting_key', 'color_settings_link')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Background Color Settings
        $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // Text Color Settings
        $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();

        // if no value, set default colors
        $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
        $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
        $this->color_settings_link = $this->color_settings_link ?: '#ca8a04';
        $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
        $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
        $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
        $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
        $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
    }

    public function render()
    {
        // dd($this->color_settings_text_light, $this->color_settings_text_dark);
        return view('livewire.customize-colors')->title('Customize Colors | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
