<?php

namespace App\Livewire;

use App\Models\SubCard;
use App\Models\User;
use Livewire\Attributes\Title;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Settings\CardDefaultsSetting;
use App\Models\UserSettings;

class CustomizationPage extends Component
{
    // Site Settings
    public $site_url;
    public $site_name;
    public $thumbnail;
    public $app_name;

    public $user;
    public $subcard_username;
    public $subcards_count;

    public $condition;
    public $card_title;

    public function profileSettings()
    {
        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();

        if ($checkifactive > 0) {
            $this->user = User::where('id', auth()->user()->id)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic', 'user_type']);
            $this->condition = ['user_id' => auth()->user()->id, 'page_id' => NULL];
        } else {
            $this->user = SubCard::where('user_id', auth()->user()->id)->where('active_card', true)->first(['username', 'firstname', 'lastname', 'job_title', 'company', 'company_website', 'bio', 'profile_pic']);
            // $this->condition = ['user_id' => auth()->user()->id, 'page_id' => $this->user->id];
            $this->condition = ['page_id' => $this->user->id];
            // dd($this->user);
        }

        $this->subcard_username = $this->user->username;
        if (!$this->subcard_username) {
            $this->subcard_username = '';
        }

        // Card title
        $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
            ->where($this->condition)
            ->pluck('setting_value')
            ->first();
    }

    public function countSubcards()
    {
        $this->subcards_count = auth()->user()->subcards()
            ->select('id', 'username', 'job_title')
            ->count();
    }

    public function mount()
    {
        $this->profileSettings();
        $this->countSubcards();
    }

    public function render()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_name = $default->site_name;
        $this->thumbnail = $default->thumbnail;
        $this->app_name = $default->app_name;

        return view('pages.customization-page', [
            'subcards_count' => $this->subcards_count,
            'subcard_username' => $this->subcard_username,
        ])->title('Customization | ' . $this->site_name)->layoutData([
            'thumbnail' => $this->thumbnail,
            'app_name' => $this->app_name,
        ]);
    }
}
