<?php

namespace App\Livewire;

use Livewire\Component;
use App\Settings\CardDefaultsSetting;
use App\Models\SubCard;
use App\Models\User;

class CopyReferCodeModal extends Component
{
    // Site Settings
    public $site_url;
    public $username;
    public $affiliate_link;

    public function mount()
    {
        $default = app(CardDefaultsSetting::class);
        $this->site_url = $default->site_url;

        $checkifactive = User::where('id', auth()->user()->id)
            ->where('active_card', true)->count();
        if ($checkifactive > 0) {

            $this->username = User::where('id', auth()->user()->id)->pluck('username')
                ->first();
        } else {
            $this->username = SubCard::where('user_id', auth()->user()->id)
                ->where('active_card', true)
                ->pluck('username')
                ->first();
        }

        $this->affiliate_link = $this->site_url . 'register?ref=' . $this->username;
    }

    public function render()
    {
        // dd($this->affiliate_link);
        return view('livewire.copy-refer-code-modal', [
            'affiliate_link' => $this->affiliate_link
        ]);
    }
}
