<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Button;
use App\Models\SubCard;
use App\Models\User;
use App\Models\UserSettings;
use App\Settings\CardDefaultsSetting;

class CommunitiesViewModal extends Component
{
    public $username;
    public $communities;
    public $condition;
    public $page_id;
    public $user;
    public $profile_layout;
    public $card_title;
    public $page_title;
    public $favicon;
    public $fullname;
    public $thumbnail;
    public $site_url;
    public $site_name;

    public $color_settings_custom_button;
    public $color_settings_custom_button_text;
    public $color_settings_profile_pic_border;
    public $color_settings_card_light;
    public $color_settings_card_dark;
    public $color_settings_text_light;
    public $color_settings_text_dark;

    //style
    public $button_style;

    public function mount($username)
    {
        $this->username = $username;

        $checkMain = User::where('username', $this->username)->count();
        $checkSub = SubCard::where('username', $this->username)->count();

        if ($checkMain > 0) {
            $this->user = User::where('username', $this->username)->where('is_active', true)->first();
            $this->condition = ['user_id' => $this->user->id, 'page_id' => NULL];
        }

        if ($checkSub > 0) {
            $this->user = SubCard::where('username', $this->username)->where('is_active', true)->first();

            $this->page_id = SubCard::where('username', $this->username)
                // ->where('active_card', true)
                ->pluck('id')
                ->first();

            $this->condition = ['page_id' => $this->page_id];
        }

        // If user exist
        if ($this->user) {

            // $this->favicon = $this->user->profile_pic;
            if ($this->user->thumbnail) {
                $this->favicon = $this->user->thumbnail;
            } else {
                $this->favicon = $this->user->profile_pic;
            }

            // Set the fullanme
            $this->fullname = $this->user->firstname . ' ' . $this->user->lastname;

            //if user exist, get contact points
            $this->communities = Button::where('is_active', true)
                ->where($this->condition)
                ->where('view', 'communities')
                ->orderBy('order', 'asc')
                ->get();

            // dd($this->communities);

            // dd($this->page_id, $this->communities, $this->condition, $this->user);

            //profile layout
            $this->profile_layout = UserSettings::where('setting_key', 'profile_layout')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            //colors
            $this->color_settings_custom_button = UserSettings::where('setting_key', 'color_settings_custom_button')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_custom_button_text = UserSettings::where('setting_key', 'color_settings_custom_button_text')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_profile_pic_border = UserSettings::where('setting_key', 'color_settings_profile_pic_border')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Card title
            $this->card_title = UserSettings::where('setting_key', 'card_custom_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            // Page title
            $this->page_title = UserSettings::where('setting_key', 'custom_page_title')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_card_light = UserSettings::where('setting_key', 'color_settings_card_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_card_dark = UserSettings::where('setting_key', 'color_settings_card_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();


            // Text Color Settings
            $this->color_settings_text_light = UserSettings::where('setting_key', 'color_settings_text_light')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->color_settings_text_dark = UserSettings::where('setting_key', 'color_settings_text_dark')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            $this->button_style = UserSettings::where('setting_key', 'button_style')
                ->where($this->condition)
                ->pluck('setting_value')
                ->first();

            if (!$this->page_title) {
                $this->page_title = $this->card_title;
            }

            if (!$this->card_title) {
                $this->card_title = $this->fullname;
            }

            $this->color_settings_custom_button_text = $this->color_settings_custom_button_text ?: '#000';
            $this->color_settings_custom_button = $this->color_settings_custom_button ?: '#facc15';
            $this->color_settings_profile_pic_border = $this->color_settings_profile_pic_border ?: '#ca8a04';
            $this->color_settings_card_light = $this->color_settings_card_light ?: '#fff';
            $this->color_settings_card_dark = $this->color_settings_card_dark ?: '#18181b';
            $this->color_settings_text_light = $this->color_settings_text_light ?: '#1e293b';
            $this->color_settings_text_dark = $this->color_settings_text_dark ?: '#cbd5e1';
            $this->profile_layout = $this->profile_layout ?? 'default';
            //style
            $this->button_style = $this->button_style ?: 'rounded';

            $default = app(CardDefaultsSetting::class);
            $this->site_name = $default->site_name;
            $this->site_url = $default->site_url;
            $this->thumbnail = $default->thumbnail;
        }
    }

    public function render()
    {
        return view('livewire.communities-view-modal')->title('Communities | ' . $this->page_title ?? $this->card_title)->layoutData([
            'favicon' => $this->favicon,
            'thumbnail' => $this->thumbnail,
            'username' => $this->username,
            'site_url' => $this->site_url,
            'title' => $this->page_title ?: $this->card_title,
            'color_settings_card_light' => $this->color_settings_card_light,
            'color_settings_card_dark' => $this->color_settings_card_dark,
            'color_settings_text_light' => $this->color_settings_text_light,
            'color_settings_text_dark' => $this->color_settings_text_dark,
        ]);
    }
}
